/**
 * 
 */
package jp.co.powerbeans.powerql.dao;

import java.util.Collection;
import java.util.Map;

/**
 * @author uu027189
 *
 */
public interface POQLMapDAO {

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#create(java.lang.Object)
	 */
	public abstract int create(Object bean);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#create(java.lang.Object, java.lang.String[])
	 */
	public abstract int create(Object bean, String[] columns);

	/**
	 * @param sql
	 * @param vals
	 * @return
	 */
	public Collection find(String sql, Object ... vals);
	
	/**
	 * @param sql
	 * @param vals
	 * @return
	 */
	public Map find1(String sql, Object ... vals);
	
	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#find1By(java.lang.String)
	 */
	public abstract Object find1By(String where);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findBy(java.lang.String)
	 */
	public abstract Collection findBy(String where);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findBy(java.lang.String, java.lang.String)
	 */
	public abstract Collection findBy(String where, String order_by);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findBy(java.lang.String, java.lang.String)
	 */
	public abstract Collection findBy(String where, String order_by,
			Object... vals);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findByAll()
	 */
	public abstract Collection findByAll();

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findByAll(java.lang.String)
	 */
	public abstract Collection findByAll(String order_by);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findByPrimaryKey(java.lang.Object)
	 */
	public abstract Object findByPrimaryKey(Object obj);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#findByPrimaryKey(int)
	 */
	public abstract Object findByPrimaryKey(int id);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#remove(java.lang.Object)
	 */
	public abstract int remove(Object bean);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#removeBy(java.lang.String)
	 */
	public abstract int removeBy(String where);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#removeByAll()
	 */
	public abstract int removeByAll();

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#removeByPrimaryKey(java.lang.Object)
	 */
	public abstract int removeByPrimaryKey(Object key);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#removeByPrimaryKey(int)
	 */
	public abstract int removeByPrimaryKey(int key);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#update(java.lang.Object)
	 */
	public abstract int update(Object bean);

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.dao.POQLDAO#update(java.lang.Object, java.lang.String[])
	 */
	public abstract int update(Object bean, String[] columns);

	/**
	 * @return the geleratedKey
	 */
	public abstract Object getGeleratedKey();

}