package jp.co.powerbeans.powerql;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * PowerQL内部ユーティリティクラス
 * @author A.Monden
 */
public final class POQLUtil {

    /**
     * 
     */
    private POQLUtil() {
        super();
    }

    /**
     * クラス名からテーブル名を作成して返す。<BR>
     * クラス名からパッケージ名を取り除いた部分をテーブル名とする。
     * @param bean クラス
     * @return テーブル名
     */
    public static String className2TableName(Class bean) { 
		int last_dot = bean.getName().lastIndexOf('.');
		if (last_dot == -1) {
			return bean.getName();
		} else {
			return bean.getName().substring(last_dot + 1);
		}
    }

    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat tf = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat dtf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    
    /**
     * 日付をyyy-MM-dd形式で返す
     * @param date
     * @return フォーマットした文字列 例) "2004-01-02"
     */
    public static String formatDate(Date date) {
        return df.format(date);
    }

    /**
     * 日付をHH:mm:ss形式で返す
     * @param date
     * @return フォーマットした文字列 例) "11:15:11"
     */
    public static String formatTime(Date date) {
        return tf.format(date);
    }

    /**
     * 日付時刻を yyy-MM-dd HH:mm:ss 形式で返す
     * @param date
     * @return フォーマットした文字列 例) "2004-01-02 11:15:11"
     */
    public static String formatDateTime(Date date) {
        return dtf.format(date);
    }

    private static final Integer static_integer[] = new Integer[256];
    static {
        for(int i = 0; i < static_integer.length; i++) {
            static_integer[i] = new Integer(i);
        }
    }
    
    /**
     * 配列からIntegerを取得。0～256のみ
     * @param i インデックス
     * @return i を Integerに変換したインスタンス
     */
    public static Integer getInteger(int i) {
        try {
            return static_integer[i];
        } catch (RuntimeException e) {
//          e.printStackTrace();
            return static_integer[0];
        }
    }
}
