package jp.co.powerbeans.powerql;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.co.powerbeans.powerql.exceptions.POQLException;
import jp.co.powerbeans.powerql.exceptions.POQLNotExistResultException;
import jp.co.powerbeans.powerql.exceptions.POQLTableNotFoundException;
import jp.co.powerbeans.powerql.util.StringUtl;
import jp.co.powerbeans.powerql.vendor.DBDependQLStatement;
import jp.co.powerbeans.powerql.vendor.DBDependQLStatementFactory;

import org.apache.oro.text.perl.Perl5Util;


/**
 * <p>タイトル: </p>
 * <p>説明: POQLStatement 共通処理実装抽象クラス</p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/05/22</p>
 * @author 門田明彦
 * @version $Revision: 1.7 $
 */
public abstract class POQLStatementSupport implements POQLStatementIF {

	/**
	 * 
	 */
	private static final Object[] EMPTY_OBJECTS = new Object[]{};

	/** regexp lib */
	private static Perl5Util perl = new Perl5Util();
	
	/** \ > \\ format */
	private static final String EN_FORMT = "s!\\\\!\\\\\\\\!g";

  /** rtrim option */
  private boolean rtrim = false;

	/**
		 * formatVal<BR>
		 * 値をSQL用にフォーマット
		 * @param o 値
		 * @return フォーマットした文字列
		 */
	public static String formatVal(Object o) {

		if (o == null) {
			return "NULL";

		} else if (o instanceof String) {

			// \ は \\ に変換
			return "'" + 
				perl.substitute(EN_FORMT, o.toString()) + "'";
////			return "'" + o.toString() + "'";

		} else if (java.util.Date.class.isInstance(o)) {
			// 日付型は '' で囲みフォーマットする
		    return "'" + POQLUtil.formatDate((Date)o) + "'";

		} else if (Calendar.class.isInstance(o)){
		    // カレンダー型は '' で囲みフォーマットする
		    
		    return "'" + POQLUtil.formatDate(((Calendar)o).getTime()) + "'";
		    
		} else if (o instanceof byte[]) {
		    // byte[] (BLOB) の場合は toString で格納。文字コードは気にしない
		    return "'" + new String((byte[])o) + "'";
		    
		} else {
			return o.toString();
		}
	}

	/**
		 * formatVal<BR>
		 * 値をSQL用にフォーマット。カラムの型により処理を分岐する
		 * @param o 値
		 * @param column_type カラムの型名
     	 * @param dep DBMS依存処理
		 * @return フォーマットした文字列
		 */
	public static String formatVal(Object o, String column_type, DBDependQLStatement dep) { 
		if (o == null) {
//			if (column_type.equalsIgnoreCase("DATE")) {
//			    return dep.getSQL_NOW("DATE");
//			}
			if (column_type.equalsIgnoreCase("TIMESTAMP")) {
			    // タイムスタンプフィールドにnullが設定されていた場合はNOW()を格納
			    return dep.getSQL_NOW("TIMESTAMP");
			}
//			else if (val == null && bp.getColumnProp().getTypeAsDB().equalsIgnoreCase("TIME")) {
//			    sql.append(dep.getSQL_NOW("TIME"));
//			}
			return "NULL";

		} else if (o instanceof String) {

			// \ は \\ に変換
			return "'" + 
				perl.substitute(EN_FORMT, o.toString()) + "'";
////			return "'" + o.toString() + "'";

		} else if (java.util.Date.class.isInstance(o)) {
			// 日付型は '' で囲みカラムの型に応じてフォーマットする
            return dep.formatDateVal((Date)o, column_type);
            //return formatDateVal((Date)o, column_type);

		} else if (Calendar.class.isInstance(o)){
		    // カレンダー型は '' で囲みフォーマットする
		    Date date = ((Calendar)o).getTime();
            return dep.formatDateVal(date, column_type);
//            return formatDateVal(date, column_type);
		    
		} else if (o instanceof byte[]) {
		    // byte[] (BLOB) の場合は toString で格納。文字コードは気にしない
		    return "'" + new String((byte[])o) + "'";
		    
		} else {
			return o.toString();
		}
	}

/** テーブル名 */
  protected String tableName;

  /** BeanClass */
  protected Class bean;

  /** このBeanが利用するMapping(BeanProperty の ArrayList) */
  protected ArrayList bpList;
  
//  /** プライマリキーの BeanProperty フィールドリスト */
//  protected BeanProperty[] bpPrimaryKey;

  /** 作成元 POQLTransaction */
  protected POQLTransaction super_tr;

  /** All Common bean mapping map (BeanProperty の ArrayListを格納) */
  protected static Map beanMap = new HashMap();

  /**
	 * createSQLMapping<BR>
	 * Bean.getXxx()の型とSQLの型のマッピングを作成。クラス変数に格納
	 */
  protected void createSQLMapping() throws POQLException, SQLException, POQLTableNotFoundException {

      bpList = getBeanPropertyList(bean, super_tr);

  }
  
  /**
	 * 一度作成したbeanMapを削除
	 * 
	 * @param bean_class
	 */
	public void removeBeamMap(Class bean_class) {
		this.beanMap.remove(bean_class.getName());
	}
  
  /**
   * Bean.getXxx()の型とSQLの型のマッピングを作成して返す
   * 
   * @return BeanPropertyのリスト
   * @throws POQLException
   * @throws SQLException
   */
    static final ArrayList getBeanPropertyList(Class bean,
            POQLTransaction super_tr) throws SQLException, POQLException {
        if (beanMap.containsKey(bean.getName())) {
            // マッピング作成済み
            return (ArrayList) beanMap.get(bean.getName());
        }

        try {
        	
	        // 新規にマッピングを作成 ----
	        String table = POQLUtil.className2TableName(bean);
	
	        // DB からカラム情報リストを取得（この順番で BeanProperty リストを作成)
	        Connection con = super_tr.getConnection();
	        ArrayList cp_list = CPCache.getColumnPropertyList(con, super_tr.mgr, table);
            DBDependQLStatement dbst = DBDependQLStatementFactory.create(con, super_tr.mgr);
	
	        if (cp_list.size() == 0) {
	        	// テーブルが無い
	        	if (super_tr.mgr.isAutoCreateTable()) {
	        		// 自動生成on の場合は自動生成を試みる
	                DBDependQLStatement dqs = DBDependQLStatementFactory.create(
	                        con, super_tr.mgr);
	                Log.println("CREATE TABLE(auto):" + table);
	                ColumnProperty[] cps = createColumnPropertyByBean(bean);
	                dqs.createTable(table, cps);
	                // 再取得
	                CPCache.remove(table);
	                cp_list = CPCache.getColumnPropertyList(con, super_tr.mgr, table);
	        	}
	        }
	        	
	        if (cp_list.size() == 0) {
	        	
	            // テーブルが無い
	            throw new POQLTableNotFoundException("cannot get table(" + table
	                    + " for bean:" + bean.getName());
	
	            // 後のバージョンで自動テーブル作成を実装
	            //			if (super_tr.mgr.isAutoCrateTable()) {
	            //				// 自動テーブル作成
	            //				createTable();
	            //				cp_list = getColumnPropertyList();
	            //				if (cp_list.size() == 0) {
	            //					throw new POQLException("fail to craete table:" +
	            // getTableName());
	            //				}
	            //			}
	        }

            // カラム情報リストの順で BeanPropertyのリストを作成していく
            ArrayList bp_list = new ArrayList(cp_list.size());
            BeanInfo info = Introspector.getBeanInfo(bean);
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            // 簡易Map作成
            HashMap prop_map = new HashMap(properties.length);
            for (int i = 0; i < properties.length; i++) {
                prop_map.put(properties[i].getName().toUpperCase(),
                        properties[i]);
            }

            for (Iterator cit = cp_list.iterator(); cit.hasNext();) {
                ColumnProperty cp = (ColumnProperty) cit.next();

                // カラム名と一致するプロパティを探す
                if (!prop_map.containsKey(cp.getName().toUpperCase())) {
                    continue; // 一致プロパティ無し
                }

                // 一致プロパティ有り
                PropertyDescriptor p = (PropertyDescriptor) prop_map.get(cp
                        .getName().toUpperCase());
                Class type = p.getPropertyType();
                String name = p.getName();
                Method m_get = p.getReadMethod();
                Method m_set = p.getWriteMethod();

                // java.util.Date 型は getter のみ存在するため
                // setter,getter両方が存在する必要はない
                //  			if (m_set == null
                //  				|| m_get == null
                //  				|| !name.toUpperCase().equals(cp.getName().toUpperCase())) {
                //  				continue;
                //  			}

                // 一致
                BeanProperty bp = new BeanProperty(type, name, m_get, m_set);
                bp.setColumnProp(cp);
                bp.setColumnPropEscapedName(dbst.escape(cp.getName()));
                bp_list.add(bp);
            }

            beanMap.put(bean.getName(), bp_list);
            prop_map = null;
            return bp_list;

        } catch (IntrospectionException e) {
            throw new POQLException(e);
        }
    }

    /**
     * bean_class からColumnProperty配列を作成する
     * @param bean_class Beanクラス
     * @return ColumnProperty配列
     * @throws IntrospectionException 
     */
    private static ColumnProperty[] createColumnPropertyByBean(Class bean_class) throws IntrospectionException {

    	List list = new ArrayList();
        BeanInfo info = Introspector.getBeanInfo(bean_class);
        PropertyDescriptor[] properties = info.getPropertyDescriptors();
        String table_name =  POQLUtil.className2TableName(bean_class);

        for (int i = 0; i < properties.length; i++) {
          Class type = properties[i].getPropertyType();
          String name = properties[i].getName();
          Method m_get = properties[i].getReadMethod();
          if (m_get != null && !"class".equals(name)) {
        	  // CPに追加
        	  ColumnProperty cp = new ColumnProperty();
        	  cp.setName(name);
        	  cp.setType(type);
        	  cp.setDefaultValue("");
        	  boolean ispk = name.toUpperCase().equals(table_name.toUpperCase() + "ID");
        	  if (ispk) {
            	  cp.setNullable(false);
            	  cp.setForceAutoValue(true); // 必ずオートナンバー型
        	  } else {
            	  cp.setNullable(true);
            	  cp.setForceAutoValue(false);
        	  }
        	  cp.setPrimaryKey(ispk);
        	  cp.setSize(getDefaultSize(type));
        	  list.add(cp);
          }
        }
//		// カラム:tableName
//		cp[0] = new ColumnProperty();
//		cp[0].setName("tableName");
//		cp[0].setNullable(false);
//		cp[0].setType(String.class);
//		//cp[1].setTypeAsDB("NUMBER");
//		cp[0].setDefaultValue("");
//		cp[0].setPrimaryKey(true);
//		cp[0].setSize(100);
//	// TODO 自動生成されたメソッド・スタブ
//	return null;
        return (ColumnProperty[]) list.toArray(new ColumnProperty[0]);
    }

	/**
	 * DBのカラムタイプと対応するデータタイプの
	 * デフォルトサイズを返す
	 * @param type タイプ(Class)
	 * @return サイズ
	 */
	private static int getDefaultSize(Class type) {
		
		if (type == String.class) {
			return 255;
		} else if (type == Integer.class) {
			return 4;
		} else if (type == Double.class) {
			return 8;
		} else {
			// ? 
			return 0;
		}
	}

	/**
     * プライマリキーのBeanPropertyを取得
     * @return プライマリキーのBeanProperty
     */
    public BeanProperty[] getPrimaryKeyBeanProperty() {
        ArrayList list = new ArrayList(1);
        for (Iterator it = bpList.iterator(); it.hasNext();) {
            BeanProperty bp = (BeanProperty) it.next();
            if (bp.getColumnProp().isPrimaryKey()) {
                list.add(bp);
            }
        }
        return (BeanProperty[]) list.toArray(new BeanProperty[0]);
    }

//  /**
//  	 * getColumnPropertyList<BR>
//  	 * カラムプロパティリストを取得
//  	 * @return
//  	 */
//  protected ArrayList getColumnPropertyList() throws POQLException, SQLException {
//  
//  	DBDependQLStatement dqs =
//  		DBDependQLStatementFactory.create(
//  			super_tr.getConnection(),
//  			super_tr.mgr);
//  
//  	return dqs.getColumnPropertyList(getTableName());
//  }

  /**
  	 * getTableName<BR>
  	 * @return
  	 */
  protected String getTableName() {
  	return tableName;
  }

  /** ResultSet から値取得用メソッド取得用パラメータ */
  protected static final Class[] RS_METHOD_PARAM = { String.class };

  /**
  	 * getValueByType<BR>
  	 * Propertyの型を判別してResultSetから値を取得する。
  	 * @param result 検索結果
  	 * @param bp BeanProperty
  	 * @return
  	 */
  protected Object getValueByType(ResultSet result, BeanProperty bp) throws POQLException, POQLNotExistResultException {
  
  	String get_method = (String) TypeMappings.java2ResultsetGetter.get(bp.getType().getName());
  	
  	if (get_method == null) {
  		// enum の場合を想定
  		if (bp.getType().isEnum()) {
  			get_method = (String) TypeMappings.java2ResultsetGetter.get("java.lang.String");
  		}
  	  	if (get_method == null) {
  	  		// not implement type
  	  		// log_?
  	  	    Log.println("getValueByType not support type:" + bp.getType().getName());
  	  		return null;
  	  	}
  	}
  	
//  	if (get_method == null) {
//  		// not implement type
//  		// log_?
//  	    Log.println("getValueByType not support type:" + bp.getType().getName());
//  		return null;
//  	} else {
  		try {
  			Method method = null;
  			if (bp.getType() == java.util.Date.class) {
  			    // 日付型で取得する場合はDBのカラムタイプからメソッドを取得
  			    String type_as_db = bp.getColumnProp().getTypeAsDB().toUpperCase();
			    if(type_as_db.startsWith("TIMESTAMP") ||
  			            type_as_db.startsWith("DATETIME") ||
                        (type_as_db.startsWith("DATE") && this.super_tr.mgr.getVendorType() == POQLManager.VENDOR_ORACLE)) {
  			        get_method = "getTimestamp";
			    }
                else if (type_as_db.startsWith("TIME")) {
  			        get_method = "getTime";
  			        
  			    } else if(type_as_db.equals("DATE")){
  			        get_method = "getDate";
  			    }
  			}
  			method =
  				ResultSet.class.getDeclaredMethod(
  					get_method,
  					RS_METHOD_PARAM);
  			Object val = method.invoke(result, new String[] { bp.getName()});
            
        if (rtrim && bp.getType() == String.class && val != null) {
          val = StringUtl.rtrim3(val.toString());
        }
        return val;
        
      } catch (InvocationTargetException e) {
            // result.getXxx() が SQLException をスローした
            // SELECT 句に bp.getName() のカラムが存在しないため値を取得できない（しない）
            // その場合は例外をスロー(呼び出し元で無視する)
            throw new POQLNotExistResultException(e);
//          return null;
        
    	} catch (Exception e) {
    		throw new POQLException(e);
    	}
//  	}
  }

  /**
  	 * getBeanByResultSet<BR>
  	 * 検索結果の現在のカーソルの行について
  	 * Mappingを利用して値を取得
  	 * @param result
  	 * @return 取得したbean
  	 */
  protected Object getBeanByResultSet(ResultSet result) throws POQLException {
  
  	try {
  		// 引数無しのpublicコンストラクタでBeanを生成
  		Object o = bean.newInstance(); // ClassLoaderの関係で生成できない場合があるので直接newする
//  		Object o = Class.forName(bean.getName()).newInstance();
  
  		// 各Property名を利用してresultから値を取得
  		for (Iterator bpit = bpList.iterator(); bpit.hasNext();) {
  			// Property
  			BeanProperty bp = (BeanProperty) bpit.next();
        
  			Object val = null;
	        try {
	          // カラム値取得
	          val = getValueByType(result, bp);
	          
	          // call setter
//	          Log.debug("setting " + bp.getM_set() + "(" + bp.getColumnProp().getName() + ")");
              
              if (val != null && val instanceof byte[] &&
                      "BLOB".equals(bp.getColumnProp().getTypeAsDB())) {
                // Blobの場合はPoqlBlobに変換して格納
                val = new PoqlBlob((byte[])val);
              }
              else if (bp.getType().isEnum()) {
            	  // Enum値を解析
            	  val = Enum.valueOf(bp.getType(), (String) val);
              }
              bp.getM_set().invoke(o, new Object[] { val });
			} catch (IllegalArgumentException e) {
				// 対象クラスのクラスローダーが置き換わった可能性があるので、
				// o から動的にメソッドを取得して値を格納してみる
				try {
					Method new_method = o.getClass().getMethod(bp.getM_set().getName(),bp.getM_set().getParameterTypes());
					if (new_method != null) {
						new_method.invoke(o, new Object[] { val });
					}
					
				} catch (Exception e1) {
					// TODO 例外はスローする?
//					throw new POQLException(e.getMessage(), e1);
				}
//				throw new POQLException(e.getMessage(), e);
	          
	        } catch (Exception e) {
	//        } catch (POQLNotExistResultException e) {
	          // 普通に発生する例外なので無視して次のフィールドを取得
	          //  e.printStackTrace(); // 何か問題があったらこの例外をチェック
	        }
  		}
  
  		return o;
  	} catch (Exception e) {
  		throw new POQLException(e);
  	}
  }
  /**
	 * getBeanByResultSet<BR>
	 * 検索結果の現在のカーソルの行をMapで取得する
	 * @param result
	 * @return 取得した行のMap(key=カラム名, value=値)
	 */
	protected Map getMapByResultSet(ResultSet result) throws POQLException {
	
		try {
			Map map = new HashMap();
			ResultSetMetaData meta = result.getMetaData();
			for(int i = 1; i <= meta.getColumnCount(); i++) {
				map.put(meta.getColumnName(i), result.getObject(i));
			}
			return map;
		} catch (Exception e) {
			throw new POQLException(e);
		}
	}
	
/**
 * o1 と o2 の fieldプロパティの値が一致するかどうかチェック
 * @param o1 比較対象Bean1
 * @param o2 比較対象Bean2
 * @param field フィールド名(プロパティ名)
 * @return true 一致, false 一致しない
 * @throws POQLException
 */
protected boolean equalFieldVal(Object o1, Object o2, String field) throws POQLException {
    
    for(Iterator it = bpList.iterator();it.hasNext();) {
        BeanProperty bp = (BeanProperty)it.next();
        if (bp.columnProp.getName().equalsIgnoreCase(field)) {
            // 一致フィールドが見つかったので値の比較を行う
            Object v1 = getValueByType(o1, bp);
            Object v2 = getValueByType(o2, bp);
            if (v1 == null || v2 == null) {
                return v1 == null && v2 == null;
            } else {
                return v1.equals(v2);
            }
        }
    }
    return false;
}

/**
 * getValueByType<BR>
 * Propertyの型を判別してResultSetから値を取得する。
 * @param o 値を取得するObject
 * @param bp 型情報
 * @return 取得したプロパティの値
 */
protected Object getValueByType(Object o, BeanProperty bp) throws POQLException {
	Method method = bp.getM_get();
	if (method == null) {
		// not implement type
		// log_?
		//			return null;
		throw new POQLException("not implement type:" + bp.getName());
	} else {
		try {
			return method.invoke(o, null);
		} catch (IllegalArgumentException e) {
			// 対象クラスのクラスローダーが置き換わった可能性があるので、
			// o から動的にメソッドを取得して値を格納してみる
			try {
				Method new_method = o.getClass().getMethod(method.getName(),method.getParameterTypes());
				if (new_method != null) {
					return new_method.invoke(o, EMPTY_OBJECTS);
				}
				
			} catch (Exception e1) {
				throw new POQLException(e.getMessage(), e1);
			}
			throw new POQLException(e.getMessage(), e);
			
		} catch (Exception e) {
			throw new POQLException(e.getMessage(), e);
		}
	}
}

/**
   * validateBean<BR>
   * ObjectがこのPowerQLがデータ格納用に利用しているBeanと同じクラスか判定
   * @param o
   */
protected void validateBean(Object o) throws POQLException {
    
    if (o == null) {
      throw new POQLException("object is null.");
    } else if (o instanceof Map) {
    	return;
    }
//    } else if (o.getClass() != bean) {
    else if (!bean.isInstance(o)) {
      throw new POQLException("object is not instanceof " + bean);
    }
    
    // valid
  }

/**
 * @return rtrim を戻します。
 */
public boolean isRtrim() {
	return rtrim;
}
/**
 * @param rtrim rtrim を設定。
 */
public void setRtrim(boolean rtrim) {
	this.rtrim = rtrim;
}
}
