package jp.co.powerbeans.powerql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import jp.co.powerbeans.powerql.exceptions.POQLException;
import jp.co.powerbeans.powerql.exceptions.POQLResultEmptyException;
import jp.co.powerbeans.powerql.exceptions.POQLResultMultiException;


/**
 * <p>タイトル: POQLStatement</p>
 * <p>説明:
 * VIEW SQL実行のためのStatement保持クラス
 *  </p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/07</p>
 * @author 門田明彦
 * @version $Revision: 1.2 $
 */
public class POQLSimpleViewStatement extends POQLViewStatementSupport {

	/** Statement */
	private Statement statement;

	/**
	 * コンストラクタ
	 * @param bean_class Beanクラス
	 * @param statement 生成済みStatement
	 * @param super_tr POQLTransaction
	 */
	public POQLSimpleViewStatement(Class bean_class, Statement statement, 
	        POQLTransaction super_tr) throws POQLException {
		
		bean = bean_class;
		this.statement = statement;
		//this.super_tr = super_tr;

		// 渡されたViewBeanのフィールドマッピングを作成
		createBeanFieldListMap();
	}

//	/**
//	 * 結合外部キーを指定して生成
//	 * @param bean_class
//	 * @param statement
//	 * @param fkeys
//	 * @param transaction
//	 */
//	public POQLSimpleViewStatement(Class bean_class, Statement statement, String[] fkeys, POQLTransaction super_tr) throws POQLException {
//		
//		bean = bean_class;
//		this.statement = statement;
//		this.fkeys = fkeys;
//		this.super_tr = super_tr;
//
//
//		// 渡されたViewBeanのフィールドマッピングを作成
//		createBeanFieldListMap();
//	}

	/**
	 * select<BR>
	 * 全件検索し結果をBeanのListで返す
	 * @param sql SQL
	 * @return BeanクラスインスタンスのCollection
	 * @throws SQLException SQL例外
	 * @throws POQLException PowerQL例外
	 */
	public Collection select(String sql) throws POQLException, SQLException {
		ArrayList result_list = new ArrayList();

		ResultSet result = statement.executeQuery(sql.toString());

		while (result.next()) {
			// 各検索結果をMappingに基づいてBeanに変換
			result_list.add(getBeanByResultSet(result));
		}

		result.close();
		return result_list;
	}

	/**
	 * selectOne<BR>
	 * 単一オブジェクトだけ取得するものとしてSELECT
	 * @param sql SQL
	 * @return BEanクラスインスタンス
	 * @throws SQLException SQL例外
	 * @throws POQLException PowerQL例外
	 * @throws POQLResultEmptyException 検索結果なしの場合の例外
	 * @throws POQLResultMultiException 検索結果複数の場合の例外
	 */
	public Object selectOne(String sql) throws SQLException,
	    POQLException, POQLResultEmptyException, POQLResultMultiException {
		Collection col = select(sql);
		if (col.isEmpty()) {
			throw new POQLResultEmptyException("検索結果 0件");
		} else if (col.size() > 1) {
			throw new POQLResultMultiException("検索結果 " + col.size() + "件");
		}
		
		Object o = null;
		for(Iterator it = col.iterator(); it.hasNext();) {
			o = it.next(); 
		}
		return o;
	}

	/* (non-Javadoc)
	 * @see jp.co.powerbeans.powerql.POQLStatementIF#close()
	 */
	public void close() throws POQLException {
		if (statement != null) {
			try {
				statement.close();
			} catch (SQLException e) {
				throw new POQLException(e);
			}
		}
	}

	/**
	 * StatementがNULL以外の場合はclose, NULLの場合は何もしない
	 * @param st Statement
	 */
	public static void closeSafe(POQLSimpleViewStatement st) {
		try {
			if (st != null) {
				st.close();
			}
		} catch (POQLException e) {
			e.printStackTrace();
		}
	}

    /* (非 Javadoc)
     * @see jp.co.powerbeans.powerql.POQLStatementIF#getLastSQL()
     */
    public String getLastSQL() {
        // 必要になったら実装
        return "";
    }

    /* (非 Javadoc)
     * @see jp.co.powerbeans.powerql.POQLStatementIF#getLastBindValues()
     */
    public Object[] getLastBindValues() {
        // 必要になったら実装
        return new Object[]{};
    }

}
