package jp.co.powerbeans.powerql;

import java.io.Serializable;

/**
 * <p>タイトル: IndexProperty</p>
 * <p>説明: テーブルのIndex属性情報。<BR>
 * 
 * </p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/14</p>
 * @author 門田明彦
 * @version $Revision$
 */
public class IndexProperty implements Serializable{

  /**
   * 
   */
  private static final long serialVersionUID = 7462185064153441911L;

  
  /** schema name */
  private String schema;
  
  /** table name */
  private String tableName;
  
  /** index name */
  private String indexName;
  
  /** column name */
  private String columnName;
  
  /** NON Unique */
  private String nonUnique;
  
  /** catalog (QUALIFIER) */
  private String catalog;
  
  /** index type */
  private short type;
  
  /** index type name  */
  private String typeName;
  

  public static long getSerialVersionUID() {
    return serialVersionUID;
  }

  public String getCatalog() {
    return catalog;
  }

  public void setCatalog(String catalog) {
    this.catalog = catalog;
  }

  public String getColumnName() {
    return columnName;
  }

  public void setColumnName(String columnName) {
    this.columnName = columnName;
  }

  public String getIndexName() {
    return indexName;
  }

  public void setIndexName(String name) {
    this.indexName = name;
  }

  public String getNonUnique() {
    return nonUnique;
  }

  public void setNonUnique(String nonUnique) {
    this.nonUnique = nonUnique;
  }

  public short getType() {
    return type;
  }

  public void setType(short s) {
    this.type = s;
  }

  public String getSchema() {
    return schema;
  }

  public void setSchema(String schema) {
    this.schema = schema;
  }

  public String getTableName() {
    return tableName;
  }

  public void setTableName(String tableName) {
    this.tableName = tableName;
  }

  public String getTypeName() {
    return typeName;
  }

  public void setTypeName(String typeName) {
    this.typeName = typeName;
  }
  
}
