package jp.co.powerbeans.powerql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import jp.co.powerbeans.powerql.exceptions.POQLException;
import jp.co.powerbeans.powerql.vendor.DBDependQLStatement;
import jp.co.powerbeans.powerql.vendor.DBDependQLStatementFactory;

/**
 * ColumnPropertyのキャッシュを管理するクラス
 * @author A.Monden
 */
public final class CPCache {

    
    private static final HashMap cpMap = new HashMap();
    /**
     * 
     */
    private CPCache() {
        super();
    }
    /**
     * bean_nameと対応するColumnPropertyのArrayListが存在するかどうか判定する
     * @param bean_name JavaBeanクラス名
     * @return true 存在する, false 存在しない
     */
    public static boolean contains(String bean_name) { 
        return cpMap.containsKey(bean_name);
    }
    
    /**
     * bean_nameと対応するColumnPropertyのArrayListを取得
     * @param bean_name JavaBeanクラス名
     * @return ColumnPropertyのArrayList, 存在しない場合は null
     */
    public static ArrayList get(String bean_name) { 
        return (ArrayList)cpMap.get(bean_name);
    }
    /**
     * bean_name のColumnPropertyリストを bean_name をキーとして格納
     * @param bean_name JavaBeanクラス名
     * @param bp_list 格納するBeanPropertyのArrayList
     */
    public static void put(String bean_name, ArrayList bp_list) {
        cpMap.put(bean_name, bp_list);
    }
    
    /**
     * tableNameで指定されたテーブルの定義情報を取得しキャッシュに格納する。
     * 2回目からはキャッシュの値を返す。
     * 速度重視のため参照で返す。
     * @param connection コネクション
     * @param mgr POQLManager
     * @param tableName テーブル名1
     * @return ColumnPropertyのArrayList
     * @throws POQLException
     * @throws SQLException
     * @throws SQLException
     */
    public static ArrayList getColumnPropertyList(Connection connection,
            POQLManager mgr, String tableName) throws SQLException, POQLException {

        if (!cpMap.containsKey(tableName)) {
            DBDependQLStatement dqs = DBDependQLStatementFactory.create(
                    connection, mgr);
            
            String schema = connection.getMetaData().getUserName();
            cpMap.put(tableName, dqs.getColumnPropertyList(tableName, schema));
            Log.println("ADD CPCACHE:" + tableName + "  CacheSize:" + cpMap.size());
        }

        return (ArrayList) cpMap.get(tableName);
    }
    
	/**
	 * ColumnPropertyキャッシュを削除する
	 * @param table_name 削除するテーブル名
	 */
	public static void remove(String table_name) {
		cpMap.remove(table_name);
        Log.println("DEL CPCACHE:" + table_name + "  CacheSize:" + cpMap.size());
	}

}
