package jp.co.powerbeans.powerql.exceptions;

/**
 * <p>タイトル: POQLTableNotFoundException</p>
 * <p>説明: POQLManager#createDAO() でDAO生成時に
 * Beanクラスと同名のテーブルが見つからない時にスローされる例外。</p>
 * <p>著作権: Copyright (c) 2003 AMsoft</p>
 * <p>Created on 2003/10/17</p>
 * @author 門田明彦
 * @version $Revision: 1.3 $
 */
public class POQLTableNotFoundException extends POQLException {

	/**
	 * コンストラクタ
	 */
	public POQLTableNotFoundException() {
		super();
	}

	/**
	 * コンストラクタ
	 * @param message メッセージ
	 */
	public POQLTableNotFoundException(String message) {
		super(message);
	}

	/**
	 * コンストラクタ
	 * @param message メッセージ
	 * @param cause 例
	 */
	public POQLTableNotFoundException(String message, Throwable cause) {
		super(message, cause);
	}

	/**
	 * コンストラクタ
	 * @param cause 例外
	 */
	public POQLTableNotFoundException(Throwable cause) {
		super(cause);
	}

}
