package jp.co.powerbeans.powerql.exceptions;

/**
 * <p>タイトル: 例外通知リスナー</p>
 * <p>説明: DAOで例外発生時にエラーを通知したい場合は
 * このインターフェースをimplementsし<BR>
 * POQLManager#setExceptionListener() で設定する。</p>
 * 
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/17</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public interface POQLExceptionListener {

    /**
     * 例外発生時にコールバックされるメソッド<BR>
     * 実装側はログ出力など独自の処理を追加できる。
     * @param throwable 発生した例外
     */
    public void onException(Throwable throwable);
}
