package jp.co.powerbeans.powerql.ds;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;

import javax.sql.DataSource;

public class POQLSingleConnectionDataSource implements DataSource {

	private String password;
	private String jdbc;
	private String url;
	private String username;
	private int loginTimeOut;
	private POQLSingleConnection con;
	private Class driver_class;

	public POQLSingleConnectionDataSource(String jdbc, String url, String username, String password) {
		this.jdbc = jdbc;
		this.url = url;
		this.username = username;
		this.password = password;
		
		this.loginTimeOut = 3000;
	}
	
	public POQLSingleConnectionDataSource(Class driver_class, String url, String username, String password) {
		this.jdbc = driver_class.getName();
		this.driver_class = driver_class;
		this.url = url;
		this.username = username;
		this.password = password;
		
		this.loginTimeOut = 3000;
	}
	
	public int getLoginTimeout() throws SQLException {
		return loginTimeOut;
	}

	public void setLoginTimeout(int seconds) throws SQLException {
		this.loginTimeOut = seconds;
	}

	public PrintWriter getLogWriter() throws SQLException {
		return null;
	}

	public void setLogWriter(PrintWriter out) throws SQLException {
	}

	public Connection getConnection() throws SQLException {
		return getConnection(this.username, this.password);
	}

	/* (non-Javadoc)
	 * @see javax.sql.DataSource#getConnection(java.lang.String, java.lang.String)
	 */
	public Connection getConnection(String username, String password)
			throws SQLException {
		try {
			if (this.con == null) {
				synchronized (POQLSingleConnectionDataSource.class) {
					if (this.con == null) {
						
						this.con = 
							this.driver_class != null ? 
									new POQLSingleConnection(this.driver_class, this.url, this.username, this.password)
							: 		new POQLSingleConnection(this.jdbc, this.url, this.username, this.password);
					}
				}
			}
			
			return this.con;
		} catch (SQLException e) {
			throw e;
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
	}

	/**
   * コネクションをクローズする
	 * @throws SQLException
	 */
	public void close() throws SQLException {
    if (this.con != null && !this.con.isClosed()) {
      this.con.closeSingle();
      this.con = null;
    }
	}
  
  /**
   * 内部コネクションがクローズしているかどうか
   * @return 
   * @return true クローズ済み, false 接続中
   * @throws SQLException 
   */
  public boolean isClosed() throws SQLException {
    return this.con != null && this.con.isClosed();
  }

public boolean isWrapperFor(Class<?> iface) throws SQLException {
	// TODO Auto-generated method stub
	return false;
}

public <T> T unwrap(Class<T> iface) throws SQLException {
	// TODO Auto-generated method stub
	return null;
}

}
