package jp.co.powerbeans.powerql.ds;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;

import jp.co.powerbeans.powerql.Log;

public class POQLSingleConnection implements Connection {


	private Connection con = null;
	
	public POQLSingleConnection(String driver_name, String url, String user, String password) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
		// ドライバをロード
		this(Class.forName(driver_name), url, user, password);
	}
	
	public POQLSingleConnection(Class driver_class, String url, String user, String password) throws InstantiationException, IllegalAccessException, SQLException {
		// ドライバをロード
			Driver driver = (Driver) driver_class.newInstance();
			
			Properties props = new Properties();
			props.put("user", user);
			props.put("password", password);
			this.con = driver.connect(url, props);
			Log.println("connect(single). user:" + user + " password:XXXX url:" + url + " con:" + con);
			
	}

	/**
	 * @throws SQLException
	 * @see java.sql.Connection#clearWarnings()
	 */
	public void clearWarnings() throws SQLException {
		con.clearWarnings();
	}

	/**
	 * @throws SQLException
	 * @see java.sql.Connection#close()
	 */
	public void close() throws SQLException {
		con.close();
	}

	/**
	 * @throws SQLException
	 * @see java.sql.Connection#commit()
	 */
	public void commit() throws SQLException {
		con.commit();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createStatement()
	 */
	public Statement createStatement() throws SQLException {
		return con.createStatement();
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @param arg2
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createStatement(int, int, int)
	 */
	public Statement createStatement(int arg0, int arg1, int arg2)
			throws SQLException {
		return con.createStatement(arg0, arg1, arg2);
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createStatement(int, int)
	 */
	public Statement createStatement(int arg0, int arg1) throws SQLException {
		return con.createStatement(arg0, arg1);
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getAutoCommit()
	 */
	public boolean getAutoCommit() throws SQLException {
		return con.getAutoCommit();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getCatalog()
	 */
	public String getCatalog() throws SQLException {
		return con.getCatalog();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getHoldability()
	 */
	public int getHoldability() throws SQLException {
		return con.getHoldability();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getMetaData()
	 */
	public DatabaseMetaData getMetaData() throws SQLException {
		return con.getMetaData();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getTransactionIsolation()
	 */
	public int getTransactionIsolation() throws SQLException {
		return con.getTransactionIsolation();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getTypeMap()
	 */
	public Map<String, Class<?>> getTypeMap() throws SQLException {
		return con.getTypeMap();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getWarnings()
	 */
	public SQLWarning getWarnings() throws SQLException {
		return con.getWarnings();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#isClosed()
	 */
	public boolean isClosed() throws SQLException {
		return con.isClosed();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#isReadOnly()
	 */
	public boolean isReadOnly() throws SQLException {
		return con.isReadOnly();
	}

	/**
	 * @param arg0
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#nativeSQL(java.lang.String)
	 */
	public String nativeSQL(String arg0) throws SQLException {
		return con.nativeSQL(arg0);
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareCall(java.lang.String, int, int, int)
	 */
	public CallableStatement prepareCall(String arg0, int arg1, int arg2,
			int arg3) throws SQLException {
		return con.prepareCall(arg0, arg1, arg2, arg3);
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @param arg2
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareCall(java.lang.String, int, int)
	 */
	public CallableStatement prepareCall(String arg0, int arg1, int arg2)
			throws SQLException {
		return con.prepareCall(arg0, arg1, arg2);
	}

	/**
	 * @param arg0
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareCall(java.lang.String)
	 */
	public CallableStatement prepareCall(String arg0) throws SQLException {
		return con.prepareCall(arg0);
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @param arg2
	 * @param arg3
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int, int, int)
	 */
	public PreparedStatement prepareStatement(String arg0, int arg1, int arg2,
			int arg3) throws SQLException {
		return con.prepareStatement(arg0, arg1, arg2, arg3);
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @param arg2
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int, int)
	 */
	public PreparedStatement prepareStatement(String arg0, int arg1, int arg2)
			throws SQLException {
		return con.prepareStatement(arg0, arg1, arg2);
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int)
	 */
	public PreparedStatement prepareStatement(String arg0, int arg1)
			throws SQLException {
		return con.prepareStatement(arg0, arg1);
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareStatement(java.lang.String, int[])
	 */
	public PreparedStatement prepareStatement(String arg0, int[] arg1)
			throws SQLException {
		return con.prepareStatement(arg0, arg1);
	}

	/**
	 * @param arg0
	 * @param arg1
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareStatement(java.lang.String, java.lang.String[])
	 */
	public PreparedStatement prepareStatement(String arg0, String[] arg1)
			throws SQLException {
		return con.prepareStatement(arg0, arg1);
	}

	/**
	 * @param arg0
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#prepareStatement(java.lang.String)
	 */
	public PreparedStatement prepareStatement(String arg0) throws SQLException {
		return con.prepareStatement(arg0);
	}

	/**
	 * @param arg0
	 * @throws SQLException
	 * @see java.sql.Connection#releaseSavepoint(java.sql.Savepoint)
	 */
	public void releaseSavepoint(Savepoint arg0) throws SQLException {
		con.releaseSavepoint(arg0);
	}

	/**
	 * @throws SQLException
	 * @see java.sql.Connection#rollback()
	 */
	public void rollback() throws SQLException {
		con.rollback();
	}

	/**
	 * @param arg0
	 * @throws SQLException
	 * @see java.sql.Connection#rollback(java.sql.Savepoint)
	 */
	public void rollback(Savepoint arg0) throws SQLException {
		con.rollback(arg0);
	}

	/**
	 * @param arg0
	 * @throws SQLException
	 * @see java.sql.Connection#setAutoCommit(boolean)
	 */
	public void setAutoCommit(boolean arg0) throws SQLException {
		con.setAutoCommit(arg0);
	}

	/**
	 * @param arg0
	 * @throws SQLException
	 * @see java.sql.Connection#setCatalog(java.lang.String)
	 */
	public void setCatalog(String arg0) throws SQLException {
		con.setCatalog(arg0);
	}

	/**
	 * @param arg0
	 * @throws SQLException
	 * @see java.sql.Connection#setHoldability(int)
	 */
	public void setHoldability(int arg0) throws SQLException {
		con.setHoldability(arg0);
	}

	/**
	 * @param arg0
	 * @throws SQLException
	 * @see java.sql.Connection#setReadOnly(boolean)
	 */
	public void setReadOnly(boolean arg0) throws SQLException {
		con.setReadOnly(arg0);
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#setSavepoint()
	 */
	public Savepoint setSavepoint() throws SQLException {
		return con.setSavepoint();
	}

	/**
	 * @param arg0
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#setSavepoint(java.lang.String)
	 */
	public Savepoint setSavepoint(String arg0) throws SQLException {
		return con.setSavepoint(arg0);
	}

	/**
	 * @param arg0
	 * @throws SQLException
	 * @see java.sql.Connection#setTransactionIsolation(int)
	 */
	public void setTransactionIsolation(int arg0) throws SQLException {
		con.setTransactionIsolation(arg0);
	}

	/**
	 * @param arg0
	 * @throws SQLException
	 * @see java.sql.Connection#setTypeMap(java.util.Map)
	 */
	public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
		con.setTypeMap(arg0);
	}

//	/* (非 Javadoc)
//	 * @see java.sql.Connection#clearWarnings()
//	 */
//	public void clearWarnings() throws SQLException {
//		con.clearWarnings();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#close()
//	 */
//	public void close() throws SQLException {
//		// close しない
////		con.close();
//	}
	/**
	 * こちらで実際にcloseする
	 * @throws SQLException
	 */
	public void closeSingle() throws SQLException {
		con.close();
	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#commit()
//	 */
//	public void commit() throws SQLException {
//		con.commit();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#createStatement()
//	 */
//	public Statement createStatement() throws SQLException {
//		return con.createStatement();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#createStatement(int, int, int)
//	 */
//	public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
//		return con.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#createStatement(int, int)
//	 */
//	public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
//		return con.createStatement(resultSetType, resultSetConcurrency);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#getAutoCommit()
//	 */
//	public boolean getAutoCommit() throws SQLException {
//		return con.getAutoCommit();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#getCatalog()
//	 */
//	public String getCatalog() throws SQLException {
//		return con.getCatalog();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#getHoldability()
//	 */
//	public int getHoldability() throws SQLException {
//		return con.getHoldability();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#getMetaData()
//	 */
//	public DatabaseMetaData getMetaData() throws SQLException {
//		return con.getMetaData();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#getTransactionIsolation()
//	 */
//	public int getTransactionIsolation() throws SQLException {
//		return con.getTransactionIsolation();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#getTypeMap()
//	 */
//	public Map getTypeMap() throws SQLException {
//		return con.getTypeMap();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#getWarnings()
//	 */
//	public SQLWarning getWarnings() throws SQLException {
//		return con.getWarnings();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#isClosed()
//	 */
//	public boolean isClosed() throws SQLException {
//		return con == null || con.isClosed();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#isReadOnly()
//	 */
//	public boolean isReadOnly() throws SQLException {
//		return con.isReadOnly();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#nativeSQL(java.lang.String)
//	 */
//	public String nativeSQL(String sql) throws SQLException {
//		return con.nativeSQL(sql);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareCall(java.lang.String, int, int, int)
//	 */
//	public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
//		return con.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareCall(java.lang.String, int, int)
//	 */
//	public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
//		return con.prepareCall(sql, resultSetType, resultSetConcurrency);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareCall(java.lang.String)
//	 */
//	public CallableStatement prepareCall(String sql) throws SQLException {
//		return con.prepareCall(sql);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareStatement(java.lang.String, int, int, int)
//	 */
//	public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
//		return con.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareStatement(java.lang.String, int, int)
//	 */
//	public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
//		return con.prepareStatement(sql, resultSetType, resultSetConcurrency);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareStatement(java.lang.String, int)
//	 */
//	public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
//		return con.prepareStatement(sql, autoGeneratedKeys);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareStatement(java.lang.String, int[])
//	 */
//	public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
//		return con.prepareStatement(sql, columnIndexes);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareStatement(java.lang.String, java.lang.String[])
//	 */
//	public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
//		return con.prepareStatement(sql, columnNames);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#prepareStatement(java.lang.String)
//	 */
//	public PreparedStatement prepareStatement(String sql) throws SQLException {
//		return con.prepareStatement(sql);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#releaseSavepoint(java.sql.Savepoint)
//	 */
//	public void releaseSavepoint(Savepoint savepoint) throws SQLException {
//		con.releaseSavepoint(savepoint);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#rollback()
//	 */
//	public void rollback() throws SQLException {
//		con.rollback();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#rollback(java.sql.Savepoint)
//	 */
//	public void rollback(Savepoint savepoint) throws SQLException {
//		con.rollback(savepoint);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#setAutoCommit(boolean)
//	 */
//	public void setAutoCommit(boolean autoCommit) throws SQLException {
//		con.setAutoCommit(autoCommit);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#setCatalog(java.lang.String)
//	 */
//	public void setCatalog(String catalog) throws SQLException {
//		con.setCatalog(catalog);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#setHoldability(int)
//	 */
//	public void setHoldability(int holdability) throws SQLException {
//		con.setHoldability(holdability);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#setReadOnly(boolean)
//	 */
//	public void setReadOnly(boolean readOnly) throws SQLException {
//		con.setReadOnly(readOnly);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#setSavepoint()
//	 */
//	public Savepoint setSavepoint() throws SQLException {
//		return con.setSavepoint();
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#setSavepoint(java.lang.String)
//	 */
//	public Savepoint setSavepoint(String name) throws SQLException {
//		return con.setSavepoint(name);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#setTransactionIsolation(int)
//	 */
//	public void setTransactionIsolation(int level) throws SQLException {
//		con.setTransactionIsolation(level);
//	}
//
//	/* (非 Javadoc)
//	 * @see java.sql.Connection#setTypeMap(java.util.Map)
//	 */
//	public void setTypeMap(Map map) throws SQLException {
//		con.setTypeMap(map);
//	}
//
//	/**
//	 * @param typeName
//	 * @param elements
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#createArrayOf(java.lang.String, java.lang.Object[])
//	 */
//	public Array createArrayOf(String typeName, Object[] elements)
//			throws SQLException {
//		return con.createArrayOf(typeName, elements);
//	}
//
//	/**
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#createBlob()
//	 */
//	public Blob createBlob() throws SQLException {
//		return con.createBlob();
//	}
//
//	/**
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#createClob()
//	 */
//	public Clob createClob() throws SQLException {
//		return con.createClob();
//	}
//
//	/**
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#createNClob()
//	 */
//	public NClob createNClob() throws SQLException {
//		return con.createNClob();
//	}
//
//	/**
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#createSQLXML()
//	 */
//	public SQLXML createSQLXML() throws SQLException {
//		return con.createSQLXML();
//	}
//
//	/**
//	 * @param typeName
//	 * @param attributes
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#createStruct(java.lang.String, java.lang.Object[])
//	 */
//	public Struct createStruct(String typeName, Object[] attributes)
//			throws SQLException {
//		return con.createStruct(typeName, attributes);
//	}
//
//	/**
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#getClientInfo()
//	 */
//	public Properties getClientInfo() throws SQLException {
//		return con.getClientInfo();
//	}
//
//	/**
//	 * @param name
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#getClientInfo(java.lang.String)
//	 */
//	public String getClientInfo(String name) throws SQLException {
//		return con.getClientInfo(name);
//	}
//
//	/**
//	 * @param timeout
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Connection#isValid(int)
//	 */
//	public boolean isValid(int timeout) throws SQLException {
//		return con.isValid(timeout);
//	}
//
//	/**
//	 * @param iface
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Wrapper#isWrapperFor(java.lang.Class)
//	 */
//	public boolean isWrapperFor(Class<?> iface) throws SQLException {
//		return con.isWrapperFor(iface);
//	}
//
//	/**
//	 * @param properties
//	 * @throws SQLClientInfoException
//	 * @see java.sql.Connection#setClientInfo(java.util.Properties)
//	 */
//	public void setClientInfo(Properties properties)
//			throws SQLClientInfoException {
//		con.setClientInfo(properties);
//	}
//
//	/**
//	 * @param name
//	 * @param value
//	 * @throws SQLClientInfoException
//	 * @see java.sql.Connection#setClientInfo(java.lang.String, java.lang.String)
//	 */
//	public void setClientInfo(String name, String value)
//			throws SQLClientInfoException {
//		con.setClientInfo(name, value);
//	}
//
//	/**
//	 * @param <T>
//	 * @param iface
//	 * @return
//	 * @throws SQLException
//	 * @see java.sql.Wrapper#unwrap(java.lang.Class)
//	 */
//	public <T> T unwrap(Class<T> iface) throws SQLException {
//		return con.unwrap(iface);
//	}

	/**
	 * @param typeName
	 * @param elements
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createArrayOf(java.lang.String, java.lang.Object[])
	 */
	public Array createArrayOf(String typeName, Object[] elements)
			throws SQLException {
		return con.createArrayOf(typeName, elements);
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createBlob()
	 */
	public Blob createBlob() throws SQLException {
		return con.createBlob();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createClob()
	 */
	public Clob createClob() throws SQLException {
		return con.createClob();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createNClob()
	 */
	public NClob createNClob() throws SQLException {
		return con.createNClob();
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createSQLXML()
	 */
	public SQLXML createSQLXML() throws SQLException {
		return con.createSQLXML();
	}

	/**
	 * @param typeName
	 * @param attributes
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#createStruct(java.lang.String, java.lang.Object[])
	 */
	public Struct createStruct(String typeName, Object[] attributes)
			throws SQLException {
		return con.createStruct(typeName, attributes);
	}

	/**
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getClientInfo()
	 */
	public Properties getClientInfo() throws SQLException {
		return con.getClientInfo();
	}

	/**
	 * @param name
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#getClientInfo(java.lang.String)
	 */
	public String getClientInfo(String name) throws SQLException {
		return con.getClientInfo(name);
	}

	/**
	 * @param timeout
	 * @return
	 * @throws SQLException
	 * @see java.sql.Connection#isValid(int)
	 */
	public boolean isValid(int timeout) throws SQLException {
		return con.isValid(timeout);
	}

	/**
	 * @param iface
	 * @return
	 * @throws SQLException
	 * @see java.sql.Wrapper#isWrapperFor(java.lang.Class)
	 */
	public boolean isWrapperFor(Class<?> iface) throws SQLException {
		return con.isWrapperFor(iface);
	}

	/**
	 * @param properties
	 * @throws SQLClientInfoException
	 * @see java.sql.Connection#setClientInfo(java.util.Properties)
	 */
	public void setClientInfo(Properties properties)
			throws SQLClientInfoException {
		con.setClientInfo(properties);
	}

	/**
	 * @param name
	 * @param value
	 * @throws SQLClientInfoException
	 * @see java.sql.Connection#setClientInfo(java.lang.String, java.lang.String)
	 */
	public void setClientInfo(String name, String value)
			throws SQLClientInfoException {
		con.setClientInfo(name, value);
	}

	/**
	 * @param <T>
	 * @param iface
	 * @return
	 * @throws SQLException
	 * @see java.sql.Wrapper#unwrap(java.lang.Class)
	 */
	public <T> T unwrap(Class<T> iface) throws SQLException {
		return con.unwrap(iface);
	}

}
