package jp.co.powerbeans.powerql;

import jp.co.powerbeans.powerql.dao.POQLAutoJoinDAO;
import jp.co.powerbeans.powerql.dao.POQLDAO;
import jp.co.powerbeans.powerql.dao.POQLDynaViewDAO;
import jp.co.powerbeans.powerql.dao.POQLRawSqlDAO;
import jp.co.powerbeans.powerql.dao.POQLViewDAO;
import jp.co.powerbeans.powerql.exceptions.POQLException;
import jp.co.powerbeans.powerql.exceptions.POQLExceptionListener;

/**
 * <p>タイトル: IPOQLManager</p>
 * <p>説明: 
 * DIコンテナでの利用を容易にするためInterface化した
 * POQLManager。<BR>
 * 
 * </p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/07</p>
 * @author 門田明彦
 * @version $Revision: 1.1 $
 */
public interface IPOQLManagerIF {

	/**
	 * isExistSequenceTable<BR>
	 * シーケンス管理テーブル存在チェック<BR>
	 * 外部からも利用可能
	 * @return true:存在, false 存在しない
	 */
	public abstract boolean isExistTable(String table_name)
			throws POQLException;

	/**
	 * getDriverName<BR>
	 * @return ドライバ名
	 */
	public abstract String getDriverName();

	/**
	 * getPassword<BR>
	 * @return 接続パスワード
	 */
	public abstract String getPassword();

	/**
	 * getUrl<BR>
	 * @return 接続URL
	 */
	public abstract String getUrl();

	/**
	 * getUser<BR>
	 * @return 接続ユーザーID
	 */
	public abstract String getUser();

	/**
	 * getPowerQLTransaction<BR>
	 * Connection を持つ POQLTransaction を作成して返す
	 * @return Connection を持つ POQLTransaction
	 */
	public abstract POQLTransaction getPowerQLTransaction()
			throws POQLException;

	/**
	 * getPowerQLTransaction<BR>
	 * Connection を渡してConnection を持つ POQLTransaction を作成して返す
	 * PowerQLTransactionクラス変数を接続情報に利用しない
	 * @param con コネクション
	 * @return Connection を持つ POQLTransaction
	 */
	public abstract POQLTransaction getPowerQLTransaction(
			java.sql.Connection con) throws POQLException;

	/**
	 * getVendorType<BR>
	 * @return ベンダー種別
	 */
	public abstract int getVendorType();

	/**
	 * getSequenceTable<BR>
	 * @return シーケンス管理テーブル名
	 */
	public abstract String getSequenceTable();

	/**
	 * POQLDAO実装クラスを生成して返す。<BR>
	 * 1つのBeanクラスに対して1種類のPOQLDAO実装クラスを生成する。
	 * 
	 * @param c Beanクラス。クラス名はテーブル名と一致する必要がある。(大文字小文字は異なってもよい)
	 * @return POQLDAO実装クラス
	 */
	public abstract POQLDAO createDAO(Class c);

	/**
	 * POQLDynaViewDAO実装クラスを生成して返す。<BR>
	 * 引数のパターンで毎に1種類のPOQLDAO実装クラスを生成する。
	 * 
	 * @param c 検索結果を格納するJavaBean
	 * @param table_beans 結合するテーブルと対応するJavaBeanの配列
	 * @param join_sql 結合SQL
	 * @return POQLDynaViewDAO実装クラス
	 */
	public abstract POQLDynaViewDAO createViewDAO(Class c, Class[] table_beans,
			String join_sql);

	/**
	 * POQLDynaViewDAO実装クラスを生成して返す。<BR>
	 * 引数のパターンで毎に1種類のPOQLDAO実装クラスを生成する。
	 * 
	 * @param c 検索結果を格納するJavaBean
	 * @param table_beans 結合するテーブルと対応するJavaBeanの配列
	 * @param join_sql 結合SQL
	 * @return POQLDynaViewDAO実装クラス
	 */
	public abstract POQLAutoJoinDAO createAutoJoinDAO(Class c,
			Class[] table_beans);

	/**
	 * POQLViewDAO実装クラスを生成して返す。<BR>
	 * 
	 * @param c 検索結果を格納するJavaBean。検索対象のVIEW名は内部でJavaBean名から取得する
	 * @return POQLViewDAO実装クラス
	 */
	public abstract POQLViewDAO createViewDAO(Class c);

	/**
	 * POQLViewDAO実装クラスを生成して返す。<BR>
	 * 
	 * @param c 結果を格納するJavaBean。sql の結果フィールドと対応するプロパティを持つ。
	 * @param sql 実行するSQL
	 * @return POQLViewDAO実装クラス
	 */
	public abstract POQLDynaViewDAO createViewDAO(Class c, String sql);

	/**
	 * POQLRawSqlDAO実装クラスを生成して返す。<BR>
	 * @return POQLRawSqlDAO 実装クラス
	 */
	public abstract POQLRawSqlDAO createRawSqlDAO();

	/**
	 * 例外リスナー取得
	 * @return Returns the exceptionListener.
	 */
	public abstract POQLExceptionListener getExceptionListener();

	/**
	 * 例外リスナー設定<BR>
	 * このメソッドで設定したリスナーはDAOに引き継がれる
	 * @param exceptionListener The exceptionListener to set.
	 */
	public abstract void setExceptionListener(
			POQLExceptionListener exceptionListener);

	/**
	 * 自動テーブル作成フラグ取得
	 * @return true 自動テーブル作成有効, false 自動テーブル作成無効
	 */
	public abstract boolean isAutoCreateTable();

	/**
	 * 自動テーブル作成フラグ設定
	 * @param autoCreateTable true 自動テーブル作成有効, false 自動テーブル作成無効 
	 */
	public abstract void setAutoCreateTable(boolean autoCreateTable);

	/**
	 * 引数のObjectの初期化メソッドを実行し
	 * 戻り値を初期データとして格納する(テーブルに存在しない場合のみ)
	 * @param bean POQLInitBeanを実装しているモデルクラス
	 * @throws POQLException 
	 */
	public abstract void initTable(Class c) throws POQLException;

	/**
	 * 全テーブルを検索するメタ情報検索メソッド
	 * @return 全テーブル配列
	 */
	public abstract TableProperty[] findSysTableAll();

	/**
	 * テーブルを検索するメタ情報検索メソッド
	 * @param schema スキーマ
	 * @return テーブル配列
	 */
	public abstract TableProperty[] findSysTableBySchema(String schema);

	/**
	 * 全スキーマを検索するメタ情報検索メソッド
	 * @return スキーマ配列
	 * @throws POQLException 
	 */
	public abstract SchemaProperty[] findSysSchemaAll();

	/**
	 * カラム情報を検索するメタ情報検索メソッド
	 * @param schema スキーマ
	 * @param table テーブル
	 * @return カラム情報. PKを含む
	 */
	public abstract ColumnProperty[] findSysColumnBySchemaTable(String schema,
			String table);

	/**
	 * インデックスを検索するメタ検索情報メソッド
	 * @param schema スキーマ
	 * @return インデックス配列
	 */
	public abstract IndexProperty[] finsSysIndexBySchemaTable(String schema,
			String table);

	/**
	 * 内部例外スローフラグを取得する
	 * @return true スローする, false スローしない
	 */
	public abstract boolean isThrowException();

	/**
	 * 内部例外スローフラグを設定する
	 * @param throwException 内部例外スローフラグ
	 */
	public abstract void setThrowException(boolean throwException);

}