package jp.co.powerbeans.powerql;

import java.io.Serializable;

/**
 * <p>タイトル: ColumnProperty</p>
 * <p>説明: BeanのPropertyが保持するDBのテーブルの１カラムのDB属性情報。<BR>
 * カラムの型、デフォルト値、NULL可不可、プライマリキーかどうか を保持する。<BR>
 * 
 * ColumnProperty is a column info of DB's table, Java Bean Property have this.<BR>
 * 
 * </p>
 * <p>著作権: 株式会社パワービーンズ</p>
 * <p>会社名: 株式会社パワービーンズ</p>
 * <p>Created on 2003/10/14</p>
 * @author 門田明彦
 * @version $Revision: 1.3 $
 */
public class ColumnProperty implements Serializable{

  /**
   * 
   */
  private static final long serialVersionUID = -4044559189008656519L;

  /** column name */
  private String name = "";
		
  /** type name as db */
  private String typeAsDB = "";
		
  /** nullable */
  private boolean nullable = false;
  
  /** not null label */
  private String notNull = "";
		
  /** default value */
  private Object defaultValue;
	
  /** type name as JAVA  */
  private Class type;
	
  /** primary key flag (true : primary key, false : not primary key) */
  private boolean primaryKey;
  
  /** primary key name (if primaryKey == true)  */
  private String primaryKeyName;
	
  /** column size (VARHAR(255)..) */
  private int size;
  
  /** INSERT時に値を指定してはいけないかどうか, true 指定してはいけない, false 指定してもOK<BR>
   * DB2 GENERATED ALWAYS 属性等が対象
   */
  private boolean forceAutoValue = false;
  
  /**
   * comment
   */
  private String comment;

  /**
   * コンストラクタ
   */
  public ColumnProperty() {
    super();
  }


  /**
   * getDefaultValue<BR>
   * @return デフォルト値
   */
  public Object getDefaultValue() {
    return defaultValue;
  }

  /**
   * getName<BR>
   * @return column name
   */
  public String getName() {
    return name;
  }

  /**
   * isNullable<BR>
   * @return can have NULL value or not? true NULL ok, false NULL NG.
   */
  public boolean isNullable() {
    return nullable;
  }

  /**
   * setDefaultValue<BR>
   * @param object デフォルト値
   */
  public void setDefaultValue(Object object) {
    defaultValue = object;
  }

  /**
   * setName<BR>
   * @param string column name
   */
  public void setName(String string) {
    name = string;
  }

  /**
   * setNullable<BR>
   * @param b Nullable flag
   */
  public void setNullable(boolean b) {
    nullable = b;
  }

  /**
   * getType<BR>
   * @return type as JAVA
   */
  public Class getType() {
    return type;
  }

  /**
   * getTypeAsDB<BR>
   * @return typeAsDB
   */
  public String getTypeAsDB() {
    return typeAsDB;
  }

  /**
   * setType<BR>
   * @param type type as JAVA
   */
  public void setType(Class type) {
    this.type = type;
  }

  /**
   * setTypeAsDB<BR>
   * @param string type as DB
   */
  public void setTypeAsDB(String string) {
    typeAsDB = string;
  }

  /**
   * isPrimaryKey<BR>
   * @return is primary key. true primary key, false not primary key.
   */
  public boolean isPrimaryKey() {
    return primaryKey;
  }

  /**
   * setPrimaryKey<BR>
   * @param b primary key flag.
   */
  public void setPrimaryKey(boolean b) {
    primaryKey = b;
  }

  /**
   * getSize<BR>
   * @return size (if type is varchar. INT..)
   */
  public int getSize() {
    return size;
  }

  /**
   * setSize<BR>
   * @param i size
   */
  public void setSize(int i) {
    size = i;
  }

/**
 * @return forceAutoValue
 */
public boolean isForceAutoValue() {
    return forceAutoValue;
}
/**
 * @param forceAutoValue forceAutoValue を設定します。
 */
public void setForceAutoValue(boolean forceAutoValue) {
    this.forceAutoValue = forceAutoValue;
}

/**
 * INSERT SQLに記述していけないカラムかどうか
 * @return true INSERT SQL に記述しない, false INSERT SQL に記述する
 */
public boolean isNotUseInsertSql() {
    return forceAutoValue;
}


public String getPrimaryKeyName() {
	return primaryKeyName;
}


public void setPrimaryKeyName(String primaryKeyName) {
	this.primaryKeyName = primaryKeyName;
}


public String getComment() {
	return comment;
}


public void setComment(String comment) {
	this.comment = comment;
}


/**
 * notNull を取得する
 * @return notNull
 */
public String getNotNull() {
  return notNull;
}


/**
 * notNull を設定する
 * @param notNull 設定する notNull
 */
public void setNotNull(String notNull) {
  this.notNull = notNull;
}

}
