package controller;

import java.util.ArrayList;
import java.util.List;

import jp.sf.beanbinder.BeanBinder;
import jp.sf.beanbinder.exception.ValidateException;
import model.Product;

public class AddProduct implements Controller {

    public void execute(BeanBinder binder) {
        try {
            //コンポーネントからオブジェクトの更新
            binder.updateObject("product");

            //商品をリストへ追加
            Product p = (Product)binder.getObject("product");
            List<Product> list = (List<Product>)binder.getObject("productList");
            if( list == null ) {
                list = new ArrayList<Product>();
                binder.setObject("productList", list);
            }
            if( p.getId() == null ) {
                p.setId(new Long(list.size()));
                list.add(p);
            }
            
            //追加したので商品を初期化
            binder.setObject("product", new Product());
            
            //コンポーネントの再描画
            binder.updateComponent(".*");
        }catch(ValidateException ex) {
            ex.printStackTrace();
        }
    }
    
}
