unit ASGSQLiteDsg;

{*_* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

Author:       Albert Drent
Description:  SQLite Design time component class
              For a description of changes, bugfixes, enhancements etc.,
              look into the ASQLite.pas file.  
Creation:     November 2003
Version:      1.2.C beta
EMail:        a.drent@aducom.com (www.aducom.com/SQLite)
Support:      support@aducom.com (www.aducom.com/SQLite)
Legal issues: Copyright (C) 2003 by Aducom Software

              Aducom Software
              Eckhartstr 61
              9746 BN  Groningen
              Netherlands

              This software is provided 'as-is', without any express or
              implied warranty.  In no event will the author be held liable
              for any damages arising from the use of this software.

              Permission is granted to anyone to use this software for any
              purpose, including commercial applications, and to alter it
              and redistribute it freely, subject to the following
              restrictions:

              1. The origin of this software must not be misrepresented,
                 you must not claim that you wrote the original software.
                 If you use this software in a product, an acknowledgment
                 in the product documentation would be appreciated but is
                 not required.

              2. Altered source versions must be plainly marked as such, and
                 must not be misrepresented as being the original software.

              3. If you make changes which improves the component you must
                 mail these to aducom as the moderator of the components
                 complete with documentation for the benefits of the community.

              4. You are not allowed to create commercial available components
                 using this software. If you use this source in any way to create
                 your own components, your source should be free of charge,
                 available to anyone. It's a far better idea to distribute your
                 changes through Aducom Software.

              5. This notice may not be removed or altered from any source
                 distribution.

              6. You must register this software by entering the support forum.
                 I like to keep track about where the components are used, so
                 sending a picture postcard to the author would be appreciated.
                 Use a nice stamp and mention your name, street
                 address, EMail address and any comment you like to say.

Acknowledgement
              These components were written for our own needs. Since SQLite is
              a freeware component we like to donate this one to the community
              too. Parts of the code is adapted from several sources, but mainly
              from the sample of Borland itself. And, of course, we did a lot
              and still are...
To Do
              A lot...
              - adding calculated fields
              etc. etc. etc.
              We are very busy, but will develop on our needs. If anyone can
              contribute, please feel welcome. Alter the source with lots of comment
              and mail it to me. If it works right I will add it to the official
              source and add your credit here below. Before you start, please
              put a request on the forum. It would be a shame if you develop something
              which already is...
*_* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * }

interface

uses
{$IFDEF VER140}
  { Delphi 6 }
  DesignIntf, DesignEditors,
{$ELSE}
{$IFDEF VER150}
  { Delphi 7 }
  DesignIntf, DesignEditors,
{$ELSE}
  DsgnIntf,
{$ENDIF}
{$ENDIF}

 FileCtrl,Classes, Controls, AMDSqlite;

type
  TDatabasePropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes      : TPropertyAttributes; override;
    function GetValue           : string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

  { Property editor for TASQLiteTable }
  TASQLiteDatabaseProperty = class(TDatabasePropertyEditor)
//    procedure GetValueList(Values: TStringList);
  end;

  TTablePropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes      : TPropertyAttributes; override;
    function GetValue           : string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

  { Property editor for TASQLiteTableNames }
  TASQLiteTableNameProperty = class(TTablePropertyEditor)
//    procedure GetValueList(Values: TStringList);
  end;

  TMasterDetailPropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes      : TPropertyAttributes; override;
    function GetValue           : string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

  { Property editor for TASQLiteMasterDetail fields }
  TASQLiteMasterDetailProperty = class(TMasterDetailPropertyEditor)
//    procedure GetValueList(Values: TStringList);
  end;

  TStoragePropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes      : TPropertyAttributes; override;
    function GetValue           : string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

  { Property editor for TASQLiteStorage fields }
  TASQLiteStorageProperty = class(TStoragePropertyEditor)
//    procedure GetValueList(Values: TStringList);
  end;

  TSyncPropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes      : TPropertyAttributes; override;
    function GetValue           : string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

  { Property editor for TASQLiteStorage fields }
  TASQLiteSyncProperty = class(TSyncPropertyEditor)
//    procedure GetValueList(Values: TStringList);
  end;

  TDirPropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes      : TPropertyAttributes; override;
    function GetValue           : string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

  { Property editor for TASQLiteStorage fields }
  TASQLiteDirProperty = class(TDirPropertyEditor)
//    procedure GetValueList(Values: TStringList);
  end;

  TDLLDirPropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes      : TPropertyAttributes; override;
    function GetValue           : string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

  { Property editor for DLL directory}
  TASQLiteDLLDirProperty = class(TDLLDirPropertyEditor)
//    procedure GetValueList(Values: TStringList);
  end;

  TFileTypePropertyEditor = class(TPropertyEditor)
  public
    function GetAttributes      : TPropertyAttributes; override;
    function GetValue           : string; override;
    procedure GetValues(Proc: TGetStrProc); override;
    procedure SetValue(const Value: string); override;
  end;

  { Property editor for TASQLiteOutputtype fields }
  TASQLiteFileTypeProperty = class(TFileTypePropertyEditor)
//    procedure GetValueList(Values: TStringList);
  end;

procedure Register;

implementation

uses ASGSQLite, SysUtils, Forms, Dialogs;

function TDatabasePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paValueList, paRevertable];
end;

procedure TDatabasePropertyEditor.GetValues(Proc: TGetStrProc);
var
  sr: TSearchRec;
begin
  with GetComponent(0) as TASQLiteDB do begin
    if DefaultExt = '' then DefaultExt := '.sdb';
    if DefaultExt[1]<> '.' then DefaultExt := '.'+DefaultExt;
    if DefaultDir <> '' then
       if DefaultDir[Length(DefaultDir)]<>'\' then
          DefaultDir := DefaultDir + '\';
    if FindFirst(DefaultDir+'*'+DefaultExt,faAnyFile, sr) = 0 then begin
       repeat
         Proc(sr.Name);
       until FindNext(sr) <> 0;
       FindClose(sr);
    end;
  end;
  Proc(':memory:');
end;

function TDatabasePropertyEditor.GetValue: string;
begin
  Result := GetStrValue;
end;

procedure TDatabasePropertyEditor.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;

//procedure TASQLiteTableNameProperty.GetValueList(Values: TStringList);
//begin
//end;

function TTablePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paMultiSelect, paDialog, paValueList, paRevertable];
end;

procedure TTablePropertyEditor.GetValues(Proc: TGetStrProc);
var MyList : TStringList;
    i      : integer;
begin
 with GetComponent(0) as TASQLiteTable do begin
  if Connection = nil then begin                         // check to see if a valid database
    raise AsgError.Create('no database connection');     // object is linked
    exit;
  end;
  MyList := TStringList.Create;
  Connection.GetTableNames(MyList, true);
  if MyList.Count > 0 then                                                      // marc 20040222
     for i := 0 to MyList.Count - 1 do Proc(MyList[i]);
  MyList.Free;
 end;
end;

function TTablePropertyEditor.GetValue: string;
begin
  Result := GetStrValue;
end;

procedure TTablePropertyEditor.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;

function TMasterDetailPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paRevertable];
end;

procedure TMasterDetailPropertyEditor.GetValues(Proc: TGetStrProc);
var
    i,p    : integer;
    r      : string;
    oldr   : string;
begin
 with GetComponent(0) as TASQLiteBaseQuery do begin
   if not Assigned(MasterSource) then begin
      Proc('');
      exit;
   end;
   if not Assigned(MasterSource.Dataset) then begin
      Proc('');
      exit;
   end;

   FMD := TFMD.Create(Application);

   if not Active then open;
   if not Active then exit;

   for i := 0 to FieldDefs.Count - 1 do
       FMD.LBDetail.Items.Add(FieldDefs.Items[i].Name);

   if not Mastersource.Dataset.Active then Mastersource.DataSet.Open;
   if not Mastersource.Dataset.Active then exit;

   for i := 0 to MasterSource.DataSet.FieldDefs.Count - 1 do
       FMD.LBMaster.Items.Add(MasterSource.DataSet.FieldDefs.Items[i].Name);

   r := MasterFields;
   Oldr := r;
   while r <> '' do begin
    p := pos(';', r);
    if p = 0 then begin
       if Trim(r) <> '' then FMD.LBLinked.Items.Add(Trim(r));
       r := '';
    end else begin
       FMD.LBLinked.Items.Add(Trim(Copy(r, 1, p-1)));
       System.Delete(r, 1, p);
    end;
   end;
   if FMD.ShowModal = mrOk then begin
      for i := 0 to FMD.LBLinked.Items.Count - 1 do begin
          r := r + FMD.LBLinked.Items[i]+';';
      end;
   end else r := oldr;
   FMD.Free;
 end;
 Proc(r);
end;

function TMasterDetailPropertyEditor.GetValue: string;
begin
  Result := GetStrValue;
end;

procedure TMasterDetailPropertyEditor.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;

function TStoragePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paRevertable];
end;

procedure TStoragePropertyEditor.GetValues(Proc: TGetStrProc);
begin
  Proc('DEFAULT');
  Proc('MEMORY');
  Proc('FILE');
end;

function TStoragePropertyEditor.GetValue: string;
begin
  Result := GetStrValue;
end;

procedure TStoragePropertyEditor.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;

function TSyncPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paRevertable];
end;

procedure TSyncPropertyEditor.GetValues(Proc: TGetStrProc);
begin
  Proc('FULL');
  Proc('NORMAL');
  Proc('OFF');
end;

function TSyncPropertyEditor.GetValue: string;
begin
  Result := GetStrValue;
end;

procedure TSyncPropertyEditor.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;

function TDirPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paRevertable];
end;

procedure TDirPropertyEditor.GetValues(Proc: TGetStrProc);
var Dir : string;
begin
  Dir := 'C:\';
  SelectDirectory(Dir, [sdAllowCreate, sdPerformCreate, sdPrompt],0);
  Proc(Dir);
end;

function TDirPropertyEditor.GetValue: string;
begin
  Result := GetStrValue;
end;

procedure TDirPropertyEditor.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;

function TDLLDirPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog, paRevertable];
end;

procedure TDLLDirPropertyEditor.GetValues(Proc: TGetStrProc);
var Dir : string;
    Drv : string;
begin
  Dir := 'C:\';
  SelectDirectory(Dir, [sdAllowCreate, sdPerformCreate, sdPrompt],0);
//  ExtractFileDrive(Dir);
//  if Drv=''
  if Dir[Length(Dir)]<>'\' then Dir := Dir +'\';
  Proc(Dir+'sqlite.dll');
end;

function TDLLDirPropertyEditor.GetValue: string;
begin
  Result := GetStrValue;
end;

procedure TDLLDirPropertyEditor.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;

function TFileTypePropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paRevertable];
end;

procedure TFileTypePropertyEditor.GetValues(Proc: TGetStrProc);
var Dir : string;
begin
  Proc('htmlfile');
  Proc('xmlfile');
  Proc('textfile');
end;

function TFileTypePropertyEditor.GetValue: string;
begin
  Result := GetStrValue;
end;

procedure TFileTypePropertyEditor.SetValue(const Value: string);
begin
  SetStrValue(Value);
end;

{ This procedure is used to register this component on the component palette }
procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(string), TASQLiteDB, 'Database',
                         TASQLiteDatabaseProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLiteDB, 'DefaultDir',
                         TASQLiteDirProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLiteDB, 'DriverDLL',
                         TASQLiteDLLDirProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLiteTable, 'TableName',
                         TASQLiteTableNameProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLiteBaseQuery, 'MasterFields',
                         TASQLiteMasterDetailProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLitePragma, 'TempStore',
                         TASQLiteStorageProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLitePragma, 'DefaultTempStore',
                         TASQLiteStorageProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLitePragma, 'Synchronous',
                         TASQLiteSyncProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLitePragma, 'DefaultSynchronous',
                         TASQLiteSyncProperty);
  RegisterPropertyEditor(TypeInfo(string), TASQLiteOutput, 'OutputType',
                         TASQLiteFileTypeProperty);

  RegisterComponents('Aducom SQLite', [TASQLiteDB]);
  RegisterComponents('Aducom SQLite', [TASQLiteQuery]);
  RegisterComponents('Aducom SQLite', [TASQLiteTable]);
  RegisterComponents('Aducom SQLite', [TASQLiteUpdateSQL]);
  RegisterComponents('Aducom SQLite', [TASQLitePragma]);
  RegisterComponents('Aducom SQLite', [TASQLiteLog]);
  RegisterComponents('Aducom SQLite', [TASQLiteInlineSQL]);
  RegisterComponents('Aducom SQLite', [TASQLiteOutput]);
end;

end.
