#include <string.h>
#include <errno.h>
#include <stdio.h>
#include <stdarg.h>
#include <usb.h>
#include "node.h"


#define	VendorID	0x04d8
#define ProductID	0x0300


struct	usb_bus	*bus;
struct	usb_bus	*busses;
struct	usb_device	*dev;
struct  usb_dev_handle *udev = NULL;

void	init_usb(void)
{
	usb_init();
 	usb_find_busses();
	usb_find_devices();
	busses = usb_get_busses();

	for (bus = busses; bus ; bus = bus->next)
	{
		for (dev = bus->devices; dev ; dev = dev->next)
		{
			if ((dev->descriptor.idVendor == VendorID)
				&& (dev->descriptor.idProduct == ProductID))
			{
				printf ("Node Adapter found\n");
				udev = usb_open(dev);
				return;
			}
		}
	}
	printf ("Node Adapter not found\n");
	exit(-1);
} 
