/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for Win32
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

#ifndef CONFIG_H
#define CONFIG_H

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#define ROTATE_NONE  0
#define ROTATE_RIGHT 1
#define ROTATE_LEFT  2

#define MAX_GAMEDESC 256

enum {
    COLUMN_GAMES = 0,
    COLUMN_ROMS,
    COLUMN_SAMPLES,
    COLUMN_DIRECTORY,
    COLUMN_TYPE,
    COLUMN_TRACKBALL,
    COLUMN_PLAYED,
    COLUMN_MANUFACTURER,
    COLUMN_YEAR,
    COLUMN_CLONE,
#ifdef MAME32JP
    COLUMN_DRIVER,
#endif
    COLUMN_MAX
};

enum {
    VIEW_LARGE_ICONS = 0,
    VIEW_SMALL_ICONS,
    VIEW_INLIST,
    VIEW_REPORT,
    VIEW_MAX
};

enum {
    SPLITTER_LEFT = 0,
    SPLITTER_RIGHT,
    SPLITTER_MAX
};

/* per-game data we calculate */
enum
{
    UNKNOWN = 2,
    GAMEDATA_MAX
};

/* Reg helpers types */
enum IniTypes
{
    IO_BOOL = 0, /* BOOL value                                            */
    IO_INT,      /* int value                                             */
    IO_DOUBLE,   /* double value         -                                */
    IO_STRING,   /* string               - m_vpData is an array           */
    IO_PSTRING,  /* pointer to string    - m_vpData is an allocated array */
    IO_ENCODE,   /* encode/decode string - calls decode/encode functions  */
    IO_SEPARATOR
};

/* List of artwork types to display in the screen shot area */
enum {
    PICT_SCREENSHOT = 0,
    PICT_FLYER,
    PICT_CABINET,
    PICT_MARQUEE,
#ifdef TAB_CONTROLL
    PICT_TITLE,
#endif /* TAB_CONTROLL */
    MAX_PICT_TYPES
};

#ifdef TAB_CONTROLL
enum
{
    HISTORY_SCREENSHOT = 0,
    HISTORY_FLYER,
    HISTORY_CABINET,
    HISTORY_MARQUEE,
    HISTORY_TITLES,
    MAX_HISTORY_TYPES
};
#endif /* TAB_CONTROLL */

/* Default input */
enum 
{
    INPUT_LAYOUT_STD,
    INPUT_LAYOUT_HR,
    INPUT_LAYOUT_HRSE,
    INPUT_LAYOUT_MAX
};

/* Reg data list */
typedef struct
{
    char m_cName[40];                             /* reg key name     */
    int  m_iType;                                 /* reg key type     */
    void *m_vpData;                               /* reg key data     */
    void (*encode)(void *data, char *str);        /* encode function  */
    void (*decode)(const char *str, void *data);  /* decode function  */
} INI_OPTIONS;

typedef struct
{
    int x, y, width, height;
} AREA;

typedef struct
{
    BOOL   use_default; /* only for non-default options */

    int    play_count;
    int    has_roms;
    int    has_samples;
    BOOL   is_favorite;
    int    autofiredelay;

    BOOL   window_mode;
    BOOL   switchres;
    int    monitor;
    int    width;
    int    height;
    int    refreshrate;
    int    brightness;
    double gamma_correct;
    int    color_depth;
    int    screen_depth;
    BOOL   autoframeskip;
    int    frameskip;
    int    rotate;
    BOOL   flipx;
    BOOL   flipy;

    BOOL   adjust_aspect;
#ifdef FSSTRETCH
    BOOL   fat_mode;
#endif
    BOOL   double_size;
#ifdef SAI
    BOOL   double_filter;
#endif
    BOOL   hscanlines;
    BOOL   vscanlines;
    int    sl_brightness;
    BOOL   hw_stretch;
    int    scale;
    BOOL   use_triplebuf;
    BOOL   tbvsync;
    BOOL   wait_vsync;
    BOOL   use_sleep;
    BOOL   use_hel;
    BOOL   use_sysmem;

    int    sound_type;
    int    samplerate;
    int    attenuation;
    int    sound_delay;
    BOOL   use_samples;
    BOOL   stereo;
    BOOL   use_filter;
    BOOL   force_panpot;
    BOOL   limit_adjust;
    BOOL   format_volume;
    BOOL   auto_adjust;
    BOOL   presoundfix;

    BOOL   use_joystick;
    BOOL   use_djoystick;
    BOOL   di_keyboard;
    int    joyid[4];
    BOOL   use_mouse;
    BOOL   di_mouse;
    BOOL   di_joystick;
    int    default_input;

    BOOL   use_artwork;
    BOOL   cheat;
    BOOL   auto_pause;
    BOOL   mame_debug;
    BOOL   disable_mmx;
    BOOL   disable_mmx2;
    BOOL   disable_pcounter;
    BOOL   errorlog;
#ifdef NFILTER
    BOOL   nfilter;
#endif
#ifdef ROMPATCH
    BOOL   patch_roms;
#endif
    BOOL   antialias;
    BOOL   translucency;
    double beam;
    int    flicker;
    BOOL   transparency;
    int    transparency_rate;
#ifdef MAME32JP
    BOOL   hiscore_force;
    BOOL   hiscore_disable;
    BOOL   blackout;		//BLACKOUT
    BOOL   autofire_message;//AUTOFIRE_MESSAGE
#endif /* MAME32JP */
#ifdef NEOGEO_BIOS_SELECT
	int    bios_type;
#else /* NEOGEO_BIOS_SELECT */
    BOOL   bios_type;/* dbg-bios */
#endif /* NEOGEO_BIOS_SELECT */
} options_type;

typedef struct
{
    INT      folder_id;
    BOOL     view;
    BOOL     show_folderlist;
    BOOL     show_toolbar;
    BOOL     show_statusbar;
    BOOL     show_screenshot;
#ifdef TAB_CONTROLL
    BOOL     history_tab;
    BOOL     show_tabctrl;
#endif /* TAB_CONTROLL */
    int      show_pict_type;
    BOOL     game_check;        /* Startup GameCheck */
    BOOL     version_check;     /* Version mismatch warings */
    BOOL     mmx_check;         /* Detect MMX processors */
#ifdef JOYGUI
    BOOL     use_joygui;        /* Allow game selection by a joystick */
    BOOL     use_joyguidi;      /* Allow game selection by a joystick */
    BOOL     use_djoygui;       /* Allow game selection by a joystick */
#endif
#ifdef RANDAM_BACKGROUND
    BOOL     random_bg;         /* Select random background image */
#endif /* RANDAM_BACKGROUND */
    char     default_game[MAX_GAMEDESC];
    int      column_width[COLUMN_MAX];
    int      column_order[COLUMN_MAX];
    int      column_shown[COLUMN_MAX];
    int      sort_column;
    BOOL     sort_reverse;
    AREA     area;
    int      splitter[SPLITTER_MAX];
    LOGFONT  list_font;
    COLORREF list_font_color;
#ifndef JAPANESE
    char*    language;
#endif

#ifdef JAPANESE
    BOOL     use_japanese_list;
    BOOL     modify_the;
#endif
#ifdef KAILLERA
    BOOL     use_netplay_folder;
    BOOL     use_ime_in_chat;
    int      chat_draw_mode;
#endif /* KAILLERA */
    BOOL     vsync_60;
    BOOL     tilemap_mmx;
} settings_type; /* global settings for the UI only */

typedef struct
{
    char     *rompath;
    char     *samplepath;
    char     *cfgdir;
#ifdef EXTRA_FOLDER
    char     *folderdir;
#endif
    char     *nvdir;
    char     *memcarddir;
    char     *inpdir;
    char     *hidir;
    char     *stadir;
    char     *artworkdir;
    char     *screenshotdir;
    char     *icondir;
    char     *wavedir;
//  char     *cheatdir;
//  char     *cheatfile;
//  char     *history_filename;
//  char     *mameinfo_filename;
    char     *flyerdir;
    char     *cabinetdir;
    char     *marqueedir;
#ifdef TAB_CONTROLL
    char     *titledir;
#endif /* TAB_CONTROLL */
#ifdef RANDAM_BACKGROUND
    char     *bgdir;
#endif /* RANDAM_BACKGROUND */
    char     *diffdir;
    char     *ctrlrdir;
} directories_type; /* directories settings for the UI only */

void win32_config_init(int total_games);
void win32_config_exit(void);

void SetPlayingGameOptions(int index);

BOOL ParseCommandLine(int argc, char *argv[], int game, int gui);

options_type * GetDefaultOptions(void);
options_type * GetGameOptions(int num_game);

void ResetGUI(void);
void ResetGameDefaults(void);
void ResetAllGameOptions(void);

void SetViewMode(int val);
int  GetViewMode(void);

#ifdef TAB_CONTROLL
void SetHistoryTab(int val);
int  GetHistoryTab(void);
#endif /* TAB_CONTROLL */

void SetGameCheck(BOOL game_check);
BOOL GetGameCheck(void);

void SetVersionCheck(BOOL version_check);
BOOL GetVersionCheck(void);

void SetMMXCheck(BOOL mmx_check);
BOOL GetMMXCheck(void);

#ifdef JOYGUI
void SetJoyGUI(BOOL use_joygui);
BOOL GetJoyGUI(void);
void SetJoyGUIDI(BOOL use_joygui);
BOOL GetJoyGUIDI(void);
void SetDJoyGUI(BOOL use_joygui);
BOOL GetDJoyGUI(void);
#endif

#ifdef RANDAM_BACKGROUND
void SetRandomBg(BOOL random_bg);
BOOL GetRandomBg(void);
#endif /* RANDAM_BACKGROUND */

void SetSavedFolderID(UINT val);
UINT GetSavedFolderID(void);

void SetShowScreenShot(BOOL val);
BOOL GetShowScreenShot(void);

#ifdef TAB_CONTROLL
void SetShowTabCtrl(BOOL val);
BOOL GetShowTabCtrl(void);
#endif /* TAB_CONTROLL */

void SetShowFolderList(BOOL val);
BOOL GetShowFolderList(void);

void SetShowStatusBar(BOOL val);
BOOL GetShowStatusBar(void);

void SetShowToolBar(BOOL val);
BOOL GetShowToolBar(void);

void SetShowPictType(int val);
int  GetShowPictType(void);

void SetDefaultGame(const char *name);
const char *GetDefaultGame(void);

void SetWindowArea(AREA *area);
void GetWindowArea(AREA *area);

void SetColumnWidths(int widths[]);
void GetColumnWidths(int widths[]);

void SetColumnOrder(int order[]);
void GetColumnOrder(int order[]);

void SetColumnShown(int shown[]);
void GetColumnShown(int shown[]);

void SetSplitterPos(int splitterId, int pos);
int  GetSplitterPos(int splitterId);

void SetListFont(LOGFONT *font);
void GetListFont(LOGFONT *font);

DWORD GetFolderFlags(char *folderName);
void  SetFolderFlags(char *folderName, DWORD dwFlags);

void SetListFontColor(COLORREF uColor);
COLORREF GetListFontColor(void);

void SetSortColumn(int column);
int  GetSortColumn(void);

const char *GetLanguage(void);
void SetLanguage(const char *language);

const char *GetRomDirs(void);
void SetRomDirs(const char *paths);

const char *GetSampleDirs(void);
void  SetSampleDirs(const char *paths);

const char *GetCfgDir(void);
void SetCfgDir(const char *path);

#ifdef EXTRA_FOLDER
const char *GetFolderDir(void);
void SetFolderDir(const char *path);
#endif

const char *GetHiDir(void);
void SetHiDir(const char *path);

const char *GetNvramDir(void);
void SetNvramDir(const char *path);

const char *GetInpDir(void);
void SetInpDir(const char *path);

const char *GetSnapDir(void);
void SetSnapDir(const char *path);

const char *GetStateDir(void);
void SetStateDir(const char *path);

const char *GetArtDir(void);
void SetArtDir(const char *path);

const char *GetMemcardDir(void);
void SetMemcardDir(const char *path);

const char *GetIconDir(void);
void SetIconDir(const char *path);

const char *GetWaveDir(void);
void SetWaveDir(const char *path);

const char *GetFlyerDir(void);
void SetFlyerDir(const char *path);

const char *GetCabinetDir(void);
void SetCabinetDir(const char *path);

const char *GetMarqueeDir(void);
void SetMarqueeDir(const char *path);

#ifdef TAB_CONTROLL
const char *GetTitleDir(void);
void SetTitleDir(const char *path);
#endif /* TAB_CONTROLL */

#ifdef RANDAM_BACKGROUND
const char *GetBgDir(void);
void SetBgDir(const char *path);
#endif /* RANDAM_BACKGROUND */

const char *GetDiffDir(void);
void SetDiffDir(const char *path);

const char *GetCtrlrDir(void);
void SetCtrlrDir(const char *path);

BOOL GameUsesTrackball(int game);

void ResetGameOptions(int num_game);

int  GetHasRoms(int num_game);
void SetHasRoms(int num_game, int has_roms);

int  GetHasSamples(int num_game);
void SetHasSamples(int num_game, int has_samples);

int  GetIsFavorite(int num_game);
void SetIsFavorite(int num_game, BOOL is_favorite);

void IncrementPlayCount(int num_game);
int  GetPlayCount(int num_game);

char * GetVersionString(void);

void SaveGameOptions(int game_num);
void SaveDefaultOptions(void);

#ifdef JAPANESE
BOOL UseJapaneseList(void);
void SetUseJapaneseList(BOOL bUse);
BOOL UseModifyThe(void);
void SetUseModifyThe(BOOL bUse);
#endif
BOOL Use60HzVsync(void);
void SetUse60HzVsync(BOOL bUse);
BOOL UseTilemapMMX(void);
void SetUseTilemapMMX(BOOL bUse);
#endif

#ifdef KAILLERA
BOOL GetNetPlayFolder(void);
void SetNetPlayFolder(BOOL bUseFavorite);
BOOL GetUseImeInChat(void);
void SetUseImeInChat(BOOL bUseIME);
BOOL GetChatDrawMode(void);
void SetChatDrawMode(int nMode);
#endif /* KAILLERA */
