/*************************************************************************

	various SNK triple Z80 games

*************************************************************************/

/*----------- defined in drivers/snk.c -----------*/

extern INTERRUPT_GEN( snk_irq_AB );
extern INTERRUPT_GEN( snk_irq_BA );

extern READ_HANDLER ( snk_cpuA_nmi_trigger_r );
extern WRITE_HANDLER( snk_cpuA_nmi_ack_w );

extern READ_HANDLER ( snk_cpuB_nmi_trigger_r );
extern WRITE_HANDLER( snk_cpuB_nmi_ack_w );

extern int snk_gamegroup;
extern int snk_sound_busy_bit;
extern int snk_irq_delay;


/*----------- defined in vidhrdw/snk.c -----------*/

extern PALETTE_INIT( snk_3bpp_shadow );
extern PALETTE_INIT( snk_4bpp_shadow );

extern VIDEO_START( snk );

extern VIDEO_UPDATE( tdfever );
extern VIDEO_UPDATE( gwar );

/*----------- defined in drivers/hal21.c -----------*/

extern PALETTE_INIT( aso );

extern UINT8 *hal21_vreg;

/*----------- defined in vidhrdw/hal21.c -----------*/

extern VIDEO_START( aso );
extern VIDEO_START( sgladiat );

extern VIDEO_UPDATE( aso );
extern VIDEO_UPDATE( sgladiat );
extern VIDEO_UPDATE( tnk3 );
extern VIDEO_UPDATE( ikari );

extern void tnk3_draw_text( struct mame_bitmap *bitmap, int bank, unsigned char *source, int mode, int flip );
extern void tnk3_draw_sprites( struct mame_bitmap *bitmap, int scrollx, int scrolly, unsigned char *source, int size, int mode, int flip );

extern int snk_bg_tilemap_baseaddr;

// note: compare tdfever which does blinking in software with tdfeverj which does it in hardware
extern int snk_blink_parity;
