/***************************************************************************

    M.A.M.E.32  -  Multiple Arcade Machine Emulator for Win32
    Win32 Portions Copyright (C) 1997-98 Michael Soderstrom and Chris Kirmse
    
    This file is part of MAME32, and may only be used, modified and
    distributed under the terms of the MAME license, in "readme.txt".
    By continuing to use, modify or distribute this file you indicate
    that you have read the license and understand and accept it fully.

 ***************************************************************************/

#ifndef __FILE_H__
#define __FILE_H__

typedef struct
{
    int index; /* into file_list, to keep track of left open files */
    int access_type;
    unsigned int crc;

    /* ACCESS_FILE */
    FILE *fptr;

    /* ACCESS_ZIP */
    unsigned char *file_data;
    unsigned int file_length;
    unsigned int file_offset;

} mame_file;

enum
{
    ACCESS_FILE = 1,
    ACCESS_ZIP  = 2,
    ACCESS_RAMFILE
};

extern int   win32_file_init(void);
extern void  win32_file_exit(void);

extern BOOL  File_ExistZip(const char *gamename, int filetype);
extern void  File_UpdateRomPath(const char *path);
extern void  File_UpdateSamplePath(const char *path);
extern BOOL  File_Status(const char *gamename,const char *filename,int filetype);

#define OSD_FILETYPE_FLYER      1001

#endif
