/*************************************************************************

	SNK NeoGeo hardware

*************************************************************************/

/*----------- defined in drivers/neogeo.c -----------*/

extern unsigned int neogeo_frame_counter;
extern unsigned int neogeo_frame_counter_speed;
extern int neogeo_raster_enable;
extern int neogeo_has_trackball;

/*----------- defined in machine/neogeo.c -----------*/

extern data16_t *neogeo_ram16;
extern data16_t *neogeo_sram16;

extern int mcd_action;
extern int mcd_number;
extern int memcard_status;
extern int memcard_number;
extern int memcard_manager;
extern UINT8 *neogeo_memcard;

MACHINE_INIT( neogeo );
DRIVER_INIT( neogeo );

WRITE16_HANDLER( neogeo_sram16_lock_w );
WRITE16_HANDLER( neogeo_sram16_unlock_w );
READ16_HANDLER( neogeo_sram16_r );
WRITE16_HANDLER( neogeo_sram16_w );

NVRAM_HANDLER( neogeo );

READ16_HANDLER( neogeo_memcard16_r );
WRITE16_HANDLER( neogeo_memcard16_w );
int neogeo_memcard_load(int);
void neogeo_memcard_save(void);
void neogeo_memcard_eject(void);
int neogeo_memcard_create(int);


/*----------- defined in machine/neocrypt.c -----------*/

extern int neogeo_fix_bank_type;

void kof99_neogeo_gfx_decrypt(int extra_xor);
void kof2000_neogeo_gfx_decrypt(int extra_xor);
void mslug4_neogeo_gfx_decrypt(int extra_xor);
#ifdef MAME32JP
void neogeo_sfix_decrypt(void);
#endif

/*----------- defined in vidhrdw/neogeo.c -----------*/

VIDEO_START( neogeo_mvs );

WRITE16_HANDLER( neogeo_setpalbank0_16_w );
WRITE16_HANDLER( neogeo_setpalbank1_16_w );
READ16_HANDLER( neogeo_paletteram16_r );
WRITE16_HANDLER( neogeo_paletteram16_w );

WRITE16_HANDLER( neogeo_vidram16_offset_w );
READ16_HANDLER( neogeo_vidram16_data_r );
WRITE16_HANDLER( neogeo_vidram16_data_w );
WRITE16_HANDLER( neogeo_vidram16_modulo_w );
READ16_HANDLER( neogeo_vidram16_modulo_r );
WRITE16_HANDLER( neo_board_fix_16_w );
WRITE16_HANDLER( neo_game_fix_16_w );
WRITE16_HANDLER (neogeo_select_bios_vectors);
WRITE16_HANDLER (neogeo_select_game_vectors);

VIDEO_UPDATE( neogeo );
VIDEO_UPDATE( neogeo_raster );
void neogeo_vh_raster_partial_refresh(struct mame_bitmap *bitmap,int current_line);

//#ifdef MAME32JP

enum {
	NEOGEOBIOS_STANDARD = 0,
//	NEOGEOBIOS_JAPAN,
	NEOGEOBIOS_DEBUG,
//	NEOGEOBIOS_TRACKBALL,
	NEOGEOBIOS_MAX
};

#define NEOGEO_MACHINE_CONSOLE   0x00
#define NEOGEO_MACHINE_ARCADE    0x04
#define NEOGEO_DEFAULT_MACHINE   NEOGEO_MACHINE_ARCADE

#define NEOGEO_COUNTRY_JAPAN     0x00
#define NEOGEO_COUNTRY_USA       0x01
#define NEOGEO_COUNTRY_EUROPE    0x02
#ifdef JAPANESE
#define NEOGEO_DEFAULT_COUNTRY   NEOGEO_COUNTRY_JAPAN
#else
#define NEOGEO_DEFAULT_COUNTRY   NEOGEO_COUNTRY_EUROPE
#endif

//#endif
