/***************************************************************************
	console.c(pong.c)
***************************************************************************/

#include "driver.h"
#include "sndintrf.h"
#include "vidhrdw/pong.h"

extern int pong_sh_start(const struct MachineSound *msound);
extern void pong_sh_stop(void);
extern void pong_sh_update(void);

INPUT_PORTS_START( console )
	PORT_START		/* IN0 buttons */
	PORT_BIT( 0x01, IP_ACTIVE_HIGH, IPT_START1 )
	PORT_DIPNAME( 0x02, 0x00, "Ending Score" )
	PORT_DIPSETTING(    0x00, "11" )
	PORT_DIPSETTING(    0x02, "15" )
	PORT_BIT( 0xfc, IP_ACTIVE_LOW,	IPT_UNUSED )

	PORT_START		/* IN1 control 1 */
	PORT_ANALOG( 0x1ff, (PONG_MAX_V-15)/2, IPT_AD_STICK_Y | IPF_PLAYER2, 100, 5, PONG_VBLANK - 12, 255)

	PORT_START		/* IN2 control 2 */
	PORT_ANALOG( 0x1ff, (PONG_MAX_V-15)/2, IPT_AD_STICK_Y, 100, 5, PONG_VBLANK - 12, 255)
INPUT_PORTS_END

static unsigned short colortable_source[] =
{
	0,1,
	1,0,
	2,0,
};

static struct CustomSound_interface custom_interface =
{
	pong_sh_start,
	pong_sh_stop,
	pong_sh_update
};

#define PONG_CLOCK	PONG_FPS * PONG_MAX_V * PONG_MAX_H + 49410   /* Pong uses a standard US TV crystal with 14,318,100 Hz */

static int pong_video[] = {
    PONG_MAX_H, PONG_MAX_V,
    0, PONG_HSYNC0, PONG_HSYNC1, PONG_HBLANK,
    0, PONG_VSYNC0, PONG_VSYNC1, PONG_VBLANK
};

static PALETTE_INIT( pong )
{
	palette_set_color(0,0x00,0x00,0x00); /* black */
	palette_set_color(1,0xff,0xff,0xff); /* white (1k resistor) */
	palette_set_color(2,0xd4,0xd4,0xd4); /* slightly darker white (1.2k resistor) */
	memcpy(colortable,colortable_source,sizeof(colortable_source));
}

static MACHINE_DRIVER_START( console )

	/* basic machine hardware */
	MDRV_CPU_ADD(GENSYNC, PONG_CLOCK)
	MDRV_CPU_CONFIG(pong_video)
	MDRV_CPU_VBLANK_INT(pong_vh_scanline, PONG_MAX_V)

	MDRV_FRAMES_PER_SECOND(PONG_FPS)
	MDRV_VBLANK_DURATION(0)  /* frames per second, vblank duration */

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(PONG_MAX_H, PONG_MAX_V)
	MDRV_VISIBLE_AREA(PONG_HBLANK, PONG_MAX_H-1, PONG_VBLANK, PONG_MAX_V-1)
	MDRV_PALETTE_LENGTH(3)
	MDRV_COLORTABLE_LENGTH(sizeof(colortable_source)/sizeof(colortable_source[0]))

	MDRV_PALETTE_INIT(pong)
	MDRV_VIDEO_START(pong)
	MDRV_VIDEO_UPDATE(pong)

	/* sound hardware */
	MDRV_SOUND_ADD(CUSTOM, custom_interface)
MACHINE_DRIVER_END

/***************************************************************************

  Game driver(s)

***************************************************************************/


#define rom_famicom 0
#define rom_twinfc 0
#define rom_disksys 0
#define rom_superfc 0
#define rom_n64 0
#define rom_gamecube 0
#define rom_q 0
#define rom_wii 0
#define rom_gameboy 0
#define rom_gbcolor 0
#define rom_supergb 0
#define rom_supergb2 0
#define rom_gblight 0
#define rom_gbpocket 0
#define rom_gba 0
#define rom_gbasp 0
#define rom_gbmicro 0
#define rom_nds 0
#define rom_ndslight 0
#define rom_ndsi 0
#define rom_nds3d 0
#define rom_ps 0
#define rom_pocketst 0
#define rom_ps2 0
#define rom_psp 0
#define rom_pspgo 0
#define rom_ps3 0

GAMEX( 198?,famicom,0, console, console, 0, ROT0,"CV","t@~[Rs[^[",GAME_NOT_WORKING )
GAMEX( 198?,twinfc,0, console, console, 0, ROT0,"V[v","cCt@~R",GAME_NOT_WORKING )
GAMEX( 198?,disksys,0, console, console, 0, ROT0,"CV","fBXNVXe",GAME_NOT_WORKING )
GAMEX( 199?,superfc,0, console, console, 0, ROT0,"CV","X[p[t@~R",GAME_NOT_WORKING )
GAMEX( 1996,n64,0, console, console, 0, ROT0,"CV","jeh[64",GAME_NOT_WORKING )
GAMEX( 2002,gamecube,0, console, console, 0, ROT0,"CV","Q[L[u",GAME_NOT_WORKING )
GAMEX( 200?,q,0, console, console, 0, ROT0,"CV/?","Q[L[u݊@ uQv (L[j",GAME_NOT_WORKING )
GAMEX( 2006,wii,0, console, console, 0, ROT0,"CV","Wii (EB[j",GAME_NOT_WORKING )
GAMEX( 1989,gameboy,0, console, console, 0, ROT0,"CV","Q[{[C",GAME_NOT_WORKING )
GAMEX( 199?,gbcolor,0, console, console, 0, ROT0,"CV","Q[{[CJ[",GAME_NOT_WORKING )
GAMEX( 199?,supergb,0, console, console, 0, ROT0,"CV","X[p[Q[{[C",GAME_NOT_WORKING )
GAMEX( 199?,supergb2,0, console, console, 0, ROT0,"CV","X[p[Q[{[C2",GAME_NOT_WORKING )
GAMEX( 199?,gblight,0, console, console, 0, ROT0,"CV","Q[{[CCg",GAME_NOT_WORKING )
GAMEX( 199?,gbpocket,0, console, console, 0, ROT0,"CV","Q[{[C|Pbg",GAME_NOT_WORKING )
GAMEX( 2001,gba,0, console, console, 0, ROT0,"CV","Q[{[CAhoX",GAME_NOT_WORKING )
GAMEX( 2003,gbasp,0, console, console, 0, ROT0,"CV","Q[{[CAhoXSP",GAME_NOT_WORKING )
GAMEX( 2004,gbmicro,0, console, console, 0, ROT0,"CV","Q[{[C~N",GAME_NOT_WORKING )
GAMEX( 2004,nds,0, console, console, 0, ROT0,"CV","jeh[DS",GAME_NOT_WORKING )
GAMEX( 2006,ndslight,0, console, console, 0, ROT0,"CV","jeh[DS Lite",GAME_NOT_WORKING )
GAMEX( 2008,ndsi,0, console, console, 0, ROT0,"CV","jeh[DSi",GAME_NOT_WORKING )
GAMEX( 2011,nds3d,0, console, console, 0, ROT0,"CV","jeh[3DS",GAME_NOT_WORKING )
GAMEX( 1994,ps,0, console, console, 0, ROT0,"\x83\x5cj[","vCXe[V",GAME_NOT_WORKING )
GAMEX( 1998,pocketst,0, console, console, 0, ROT0,"\x83\x5cj[","|PbgXe[V",GAME_NOT_WORKING )
GAMEX( 2000,ps2,0, console, console, 0, ROT0,"\x83\x5cj[","vCXe[V2",GAME_NOT_WORKING )
GAMEX( 2006,ps3,0, console, console, 0, ROT0,"\x83\x5cj[","vCXe[V3",GAME_NOT_WORKING )
GAMEX( 2004,psp,0, console, console, 0, ROT0,"\x83\x5cj[","vCXe[V|[_v",GAME_NOT_WORKING )
GAMEX( 2009,pspgo,0, console, console, 0, ROT0,"\x83\x5cj[","PSPgo",GAME_NOT_WORKING )











