/***************************************************************************

  win32.h

  OS dependent stuff

 ***************************************************************************/

#ifndef WIN32MAME_H
#define WIN32MAME_H

#include "win32ui.h"
#include "config.h"

#if !defined(MAME32NAME)
#if defined(KAILLERA)
#define MAME32NAME "atMAME32kjp 0.68.04"
#else
#define MAME32NAME "atMAME32kjp (No Kaillera Version) 0.68.04"
#endif
#endif

#if !defined(MAMENAME)
#if defined(KAILLERA)
#define MAMENAME "atMAMEWkjp"
#else
#define MAMENAME "atMAMEWkjp (No Kaillera Version)"
#endif
#endif


#define HANDLE_MESSAGE(hwnd, message, fn)                               \
    case (message):                                                     \
    {                                                                   \
        *pResult = HANDLE_##message((hwnd), (wParam), (lParam), (fn));  \
        return TRUE;                                                    \
    }

#define PEEK_MESSAGE(hwnd, message, fn)                                 \
    case (message):                                                     \
    {                                                                   \
        *pResult = HANDLE_##message((hwnd), (wParam), (lParam), (fn));  \
        return FALSE;                                                   \
    }


struct tMAME32App
{
    HWND               m_hwndUI;
    HWND               m_hWnd;
    HICON              m_hIcon;
    HCURSOR            m_hCursor;
    const char         *m_Name;
    options_type       *m_Options;

    BOOL               m_bIsInitialized;
    BOOL               m_bIsActive;
    BOOL               m_bAutoPaused;
    BOOL               m_bMamePaused;
    BOOL               m_bDone;
    int                m_nMMXDetected;

    /*
        TRUE if using m_pTrak for standard analog inputs,
        FALSE if using m_pJoystick for standard analog inputs.
    */
    BOOL               m_bUseAIMouse;

    struct OSDKeyboard *m_pKeyboard;
    struct OSDJoystick *m_pJoystick;
    struct OSDMouse    *m_pMouse;

    void               (*ProcessMessages)(void);
    BOOL               (*PumpAndReturnMessage)(MSG* pMsg);
    void               (*HandleAutoPause)(void);
    void               (*Quit)(void);
    int                (*DetectMMX)(void);
    BOOL               (*Done)(void);
};


extern int get_game_count(void);

extern struct tMAME32App MAME32App;

#endif
