using System;
using System.Collections.Generic;
using System.Reflection;
using NaGet.Packages;

namespace NaGet.Packages.Install
{
	/// <summary>
	/// XV\tgT
	/// </summary>
	public sealed class UpgradeFinder
	{
		private UpgradeFinder()
		{
		}
		
		private static Package getUpgradePkg(Package pkg, PackageList<Package> pkgList, PackageList<InstalledPackage> instPkgList, string[] exclude, IComparer<string> verComp)
		{
			Package avaiablePkg = pkgList.GetPackageForName(pkg.Name);
			bool canUpgrade = false;
			
			if (avaiablePkg != null) {
				
				if (verComp.Compare(pkg.Version, avaiablePkg.Version) < 0 &&
				    instPkgList.GetPackageForPackage(pkg.Name, avaiablePkg.Version) == null) {
					canUpgrade = true;
					
					if (Array.IndexOf(exclude, pkg.Name) >= 0) {
						canUpgrade = false;
					} else if (Installation.GetPreferInstallerIndex(pkg) == -1) {
						canUpgrade = false;
					}
				}
			}
			
			return (canUpgrade)? avaiablePkg : null;
		}
		
		public static IEnumerable<Package> GetUpgradePackages(PackageListsManager pkgListMan)
		{
			PackageList<Package> packageList = pkgListMan.AvailablePkgList;
			string[] exclude = NaGet.Env.ExcludeUpdatePackageNames ?? new string[0];
			
			VersionComparetor verComp = new VersionComparetor();
			
			foreach (InstalledPackage pkg in pkgListMan.InstalledPkgList) {
				Package availablePkg = getUpgradePkg(pkg, packageList, pkgListMan.InstalledPkgList, exclude, verComp);
				if (availablePkg != null) { // if it has an upgrade, yield
					yield return availablePkg;
				}
			}
			foreach (InstalledPackage pkg in pkgListMan.SystemInstalledPkgList) {
				Package availablePkg = getUpgradePkg(pkg, packageList, pkgListMan.SystemInstalledPkgList, exclude, verComp);
				if (availablePkg != null) { // if it has an upgrade, yield
					yield return availablePkg;
				}
			}
		}
	}
}
