﻿using System;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace NaGet.InteropServices
{
	/// <summary>
	/// Windows Os Version
	/// </summary>
	public sealed class WindowsVersion
	{
		[DllImport("ntdll.dll", SetLastError=true)]
		private static extern int RtlGetVersion([In, Out] ref OSVERSIONINFOEX lpVersionInformation);
		
		[StructLayout(LayoutKind.Sequential)]
		private struct OSVERSIONINFOEX
		{
			public uint dwOSVersionInfoSize;
			public uint dwMajorVersion;
			public uint dwMinorVersion;
			public uint dwBuildNumber;
			public uint dwPlatformId;
			[MarshalAs(UnmanagedType.ByValTStr, SizeConst=128)]
			public string szCSDVersion;
			public ushort wServicePackMajor;
			public ushort wServicePackMinor;
			public ushort wSuiteMask;
			public char wProductType;
			public char wReserved;
		}
		
		public struct VersionInfo {
			public uint MajorVersion;
			public uint MinorVersion;
			public uint BuildNumber;
			public ushort ServicePackMajor;
			public ushort ServicePackMinor;
		}
		
		public static VersionInfo? GetVersionInfo() {
			VersionInfo? retval = null;
			
			try {
				OSVERSIONINFOEX versionInformation = new OSVERSIONINFOEX();
				versionInformation.dwOSVersionInfoSize = (uint)Marshal.SizeOf(versionInformation);
				
				int result = RtlGetVersion(ref versionInformation);
				if (result == 0) {
					VersionInfo info = new VersionInfo();
					info.MajorVersion = versionInformation.dwMajorVersion;
					info.MinorVersion = versionInformation.dwMinorVersion;
					info.BuildNumber = versionInformation.dwBuildNumber;
					info.ServicePackMajor = versionInformation.wServicePackMajor;
					info.ServicePackMinor = versionInformation.wServicePackMinor;
					
					retval = info;
				}	
			} catch (Exception) {
				// Drop any exception
			}
			
			return retval;
		}
	}
}
