/*
 * ĿͼѤδؿ
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 10/24
 *
 * Copyright (C) 2001-2003 TABATA Yusuke
 *
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <conf.h>
#include <dic.h>
#include <record.h>
#include <dicutil.h>

static int gIsInit;

/* recordƱindexβܤͤФ */
static int gOffset;

/** Ŀͼ饤֥ */
void
anthy_dic_util_init(void)
{
  if (gIsInit) {
    return ;
  }
  if (anthy_init_dic() == -1) {
    return ;
  }
  anthy_dic_set_personality("default");
  gIsInit = 1;
}

/** 饤֥ */
void
anthy_dic_util_quit(void)
{
  if (gIsInit) {
    anthy_quit_dic();
  }
}

void
anthy_dic_util_set_personality(char *id)
{
  anthy_dic_set_personality(id);
}

/** Ŀͼä */
void
anthy_priv_dic_delete(void)
{
  if (anthy_select_section("PRIVATEDIC", 0) == -1) {
    return ;
  }
  anthy_release_section();
}

/** ǽñ򤹤 */
int
anthy_priv_dic_select_first_entry(void)
{
  if (anthy_select_section("PRIVATEDIC", 0) == -1) {
    return -1;
  }
  gOffset = 0;
  return anthy_select_first_column();
}

/** 򤵤Ƥñμñ򤹤 */
int
anthy_priv_dic_select_next_entry(void)
{
  int nr = anthy_get_nr_values();
  if (nr > gOffset + 3) {
    gOffset += 3;
    return 0;
  }
  gOffset = 0;
  return anthy_select_next_column();
}

/** ̤ */
int
anthy_priv_dic_select_entry(char *index)
{
  (void)index;
  return 0;
}

/** 򤵤Ƥñɤߤ */
char *
anthy_priv_dic_get_index(char *buf, int len)
{
  xstr *xs;
  xs = anthy_get_index_xstr();
  if (!xs) {
    return 0;
  }
  if (anthy_snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

/** 򤵤Ƥñɤߤ */
int
anthy_priv_dic_get_freq(void)
{
  return anthy_get_nth_value(gOffset + 2);
}

/** 򤵤Ƥñʻ */
char *
anthy_priv_dic_get_wtype(char *buf, int len)
{
  xstr *xs = anthy_get_nth_xstr(gOffset + 1);
  if (!xs) {
    return 0;
  }
  if (anthy_snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

/** 򤵤Ƥñ */
char *
anthy_priv_dic_get_word(char *buf, int len)
{
  xstr *xs = anthy_get_nth_xstr(gOffset);
  if (!xs) {
    return 0;
  }
  if (anthy_snputxstr(buf, len, xs) == len) {
    return 0;
  }
  return buf;
}

/* ñϿ׻ */
static int
get_offset(xstr *word, xstr *wt)
{
  int i, nr = anthy_get_nr_values();
  for (i = 0; i < nr; i+= 3) {
    xstr *xs;
    xs = anthy_get_nth_xstr(i);
    if (!anthy_xstrcmp(word, xs)) {
      xs = anthy_get_nth_xstr(i + 1);
      if (!anthy_xstrcmp(wt, xs)) {
	return i;
      }
    }
  }
  return nr;
}

/** Ԥshrink/0ΤΤä
 */
static void
shrink_column(void)
{
  int nr, i, nth;
  struct priv_ent {
    xstr *word_xs;
    xstr *wt_xs;
    int freq;
  } * priv_array;
  xstr *index = anthy_get_index_xstr();

  nr = anthy_get_nr_values() / 3;
  priv_array = alloca(sizeof(struct priv_ent) * nr);
  nth = 0;
  for (i = 0; i < nr; i++) {
    int freq = anthy_get_nth_value(i * 3 + 2);
    if (freq) {
      priv_array[nth].word_xs = anthy_get_nth_xstr(i * 3);
      priv_array[nth].wt_xs = anthy_get_nth_xstr(i * 3 + 1);
      priv_array[nth].freq = freq;
      nth ++;
    }
  }
  if (nth == nr) {
    return ;
  }
  if (!nth) {
    anthy_release_column();
  } else {
    int res;
    index = anthy_xstr_dup(index);
    anthy_release_column();
    res = anthy_select_column(index, 1);
    if (res == -1) {
      anthy_free_xstr(index);
      return ;
    }
    for (i = 0; i < nth; i++) {
      anthy_set_nth_xstr(nth * 3, priv_array[nth].word_xs);
      anthy_set_nth_xstr(nth * 3 + 1, priv_array[nth].wt_xs);
      anthy_set_nth_value(nth * 3 + 2, priv_array[nth].freq);
    }
    anthy_free_xstr(index);
  }
}

/** ñϿ */
int
anthy_priv_dic_add_entry(char *yomi, char *word,
			 char *wt_name, int freq)
{
  xstr *xs, *word_xs, *wt_xs;
  int offset, res;

  if (anthy_select_section("PRIVATEDIC", 1) == -1) {
    return ANTHY_DIC_UTIL_ERROR;
  }
  /* ɤߤ򤹤*/
  xs = anthy_cstr_to_xstr(yomi, 0);
  if (anthy_select_column(xs, 1) == -1) {
    anthy_free_xstr(xs);
    return ANTHY_DIC_UTIL_ERROR;
  }
  anthy_free_xstr(xs);

  /* Ʊñ줬Ǥˤä餽˾񤭡ʤкǸ */
  word_xs = anthy_cstr_to_xstr(word, 0);
  wt_xs = anthy_cstr_to_xstr(wt_name, 0);
  offset = get_offset(word_xs, wt_xs);
  if (offset < anthy_get_nr_values()) {
    res = ANTHY_DIC_UTIL_DUPLICATE;
  } else {
    res = ANTHY_DIC_UTIL_OK;
  }
  /* ñϿ */
  anthy_set_nth_xstr(offset, word_xs);
  anthy_free_xstr(word_xs);
  /* ʻϿ */
  anthy_set_nth_xstr(offset + 1, wt_xs);
  anthy_free_xstr(wt_xs);
  /*  */
  anthy_set_nth_value(offset + 2, freq);
  anthy_mark_column_used();
  /**/
  shrink_column();

  return res;
}

const char *
anthy_dic_util_get_anthydir(void)
{
  return anthy_conf_get_str("ANTHYDIR");
}
