/*
 * ĿͼѤδؿ
 *
 * ߴԹ
 *  utf8μtextdict
 *  eucjpμtexttrie
 *  recordȤäƤƺ𤷤ޤ
 * textdictذܹԤ
 *
 * ȯͽ
 *
 *  ϿtextdictФƹԤ褦ˤ <- todo
 *  texttrieñϰܹԤ褦ˤ
 *  recordطϾä
 *
 *
 * Funded by IPA̤Ƨեȥ¤ 2001 10/24
 *
 * Copyright (C) 2001-2007 TABATA Yusuke
 *
 */
/*
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <anthy.h>
#include <conf.h>
#include <dic.h>
#include <texttrie.h>
#include <textdict.h>
#include <record.h>
#include <dicutil.h>

#include "dic_main.h"
#include "dic_personality.h"

/*
 * Ŀͼtexttrie˳ǼȤ
 *   Ф  -> #ʻ* ñפȤȤ
 * (UTF8ξϡ pФ  -> #ʻ* ñ)
 * ǽ2ʸζñΥǤ뤳Ȥ̣
 * ʬƱ̤뤿Ѥ롣
 *
 */

/* UTF832ʸ x 3bytes */
#define MAX_KEY_LEN 96

static int gIsInit;
static int dic_util_encoding;

extern struct text_trie *anthy_private_tt_dic;
extern struct textdict *anthy_private_text_dic;
/* 򤵤Ƥɤ */
static struct iterate_contex {
  /**/
  int in_tt;
  /* texttrie */
  char key_buf[MAX_KEY_LEN+32];
  /* textdictθ */
  int dicfile_offset;
  char *current_index;
  char *current_line;
} word_iterator;
/**/
struct scan_context {
  const char *yomi;
  const char *word;
  const char *wt_name;
  int offset;
  int found_word;
};

static void
set_current_line(const char *index, const char *line)
{
  if (word_iterator.current_line) {
    free(word_iterator.current_line);
    word_iterator.current_line = NULL;
  }
  if (line) {
    word_iterator.current_line = strdup(line);
  }
  if (word_iterator.current_index) {
    free(word_iterator.current_index);
    word_iterator.current_index = NULL;
  }
  if (index) {
    word_iterator.current_index = strdup(index);
  }
}

/** Ŀͼ饤֥ */
void
anthy_dic_util_init(void)
{
  if (gIsInit) {
    return ;
  }
  if (anthy_init_dic() == -1) {
    return ;
  }
  anthy_dic_set_personality("default");
  gIsInit = 1;
  dic_util_encoding = ANTHY_EUC_JP_ENCODING;
  /**/
  word_iterator.key_buf[0] = 0;
  word_iterator.in_tt = 1;
}

/** 饤֥ */
void
anthy_dic_util_quit(void)
{
  if (gIsInit) {
    anthy_quit_dic();
  }
  set_current_line(NULL, NULL);
  gIsInit = 0;
}

/** 桼ƥƥAPIΥ󥳡ǥ󥰤ꤹ */
int
anthy_dic_util_set_encoding(int enc)
{
  if (enc == ANTHY_UTF8_ENCODING ||
      enc == ANTHY_EUC_JP_ENCODING) {
    dic_util_encoding = enc;
  }
  return dic_util_encoding;
}

void
anthy_dic_util_set_personality(const char *id)
{
  anthy_dic_set_personality(id);
}

static char *
find_next_key(const char *prefix)
{
  char *v;
  v = anthy_trie_find_next_key(anthy_private_tt_dic,
			       word_iterator.key_buf, MAX_KEY_LEN+32);

  if (v && v[0] == prefix[0] && v[1] == prefix[1]) {
    /* keyꤵ줿prefixäƤ */
    return v;
  }
  /**/
  sprintf(word_iterator.key_buf, prefix);
  return NULL;
}

static void
delete_prefix(const char *prefix)
{
  sprintf(word_iterator.key_buf, prefix);
  anthy_priv_dic_lock();
  /* word_iterator.key_bufprefixʸǤСfind_next_key()
     ǽñ֤ */
  while (find_next_key(prefix)) {
    anthy_trie_delete(anthy_private_tt_dic, word_iterator.key_buf);
    sprintf(word_iterator.key_buf, prefix);
  }
  anthy_priv_dic_unlock();
}

static const char *
encoding_prefix(int encoding)
{
  if (encoding == ANTHY_UTF8_ENCODING) {
    return " p";
  }
  /* EUC-JP */
  return "  ";
}

/** (API) Ŀͼä */
void
anthy_priv_dic_delete(void)
{
  delete_prefix(encoding_prefix(ANTHY_EUC_JP_ENCODING));
  /**/
  while (!anthy_textdict_delete_line(anthy_private_text_dic, 0)) {
    /**/
  }
  /* μ */
  if (!anthy_select_section("PRIVATEDIC", 0)) {
    anthy_release_section();
    return ;
  }
}

static int
scan_cb(void *p, int next_offset, const char *key, const char *n)
{
  (void)p;
  set_current_line(key, n);
  word_iterator.dicfile_offset = next_offset;
  return -1;
}

static int
select_first_entry_in_textdict(void)
{
  word_iterator.dicfile_offset = 0;
  set_current_line(NULL, NULL);
  anthy_textdict_scan(anthy_private_text_dic,
		      word_iterator.dicfile_offset, NULL,
		      scan_cb);
  if (word_iterator.current_line) {
    word_iterator.in_tt = 0;
    return 0;
  }
  /* ñ줬̵ */
  return ANTHY_DIC_UTIL_ERROR;
}

/** (API) ǽñ򤹤 */
int
anthy_priv_dic_select_first_entry(void)
{
  if (dic_util_encoding == ANTHY_UTF8_ENCODING) {
    return select_first_entry_in_textdict();
  }
  if (!anthy_private_tt_dic) {
    return ANTHY_DIC_UTIL_INVALID;
  }
  sprintf(word_iterator.key_buf, encoding_prefix(dic_util_encoding));
  /* prefixμΥȥ꤬ǽΥȥ */
  if (find_next_key(encoding_prefix(dic_util_encoding))) {
    word_iterator.in_tt = 1;
    return 0;
  }
  /* ñ줬̵Τtextdict˰ưߤ */
  return select_first_entry_in_textdict();
}

/** (API) 򤵤Ƥñμñ򤹤 */
int
anthy_priv_dic_select_next_entry(void)
{
  if (!word_iterator.in_tt) {
    set_current_line(NULL, NULL);
    anthy_textdict_scan(anthy_private_text_dic, word_iterator.dicfile_offset,
			NULL,
			scan_cb);
    if (word_iterator.current_line) {
      return 0;
    }
    return ANTHY_DIC_UTIL_ERROR;
  }
  if (find_next_key(encoding_prefix(dic_util_encoding))) {
    return 0;
  }
  /* ñ줬̵Τtextdict˰ưߤ */
  return select_first_entry_in_textdict();
}

/** ̤ */
int
anthy_priv_dic_select_entry(const char *index)
{
  (void)index;
  return 0;
}

/** 򤵤Ƥñɤߤ */
char *
anthy_priv_dic_get_index(char *buf, int len)
{
  int i;
  char *src_buf;
  if (word_iterator.in_tt) {
    src_buf = &word_iterator.key_buf[2];
  } else {
    src_buf = word_iterator.current_index;
  }
  if (!word_iterator.in_tt && dic_util_encoding == ANTHY_EUC_JP_ENCODING) {
    /**/
    src_buf = anthy_conv_utf8_to_euc(src_buf);
  } else {
    src_buf = strdup(src_buf);
  }
  /* ǽζ\0ޤǤ򥳥ԡ */
  for (i = 0; src_buf[i] && src_buf[i] != ' '; i++) {
    if (i >= len - 1) {
      free(src_buf);
      return NULL;
    }
    buf[i] = src_buf[i];
  }
  buf[i] = 0;
  free(src_buf);
  return buf;
}

/** 򤵤Ƥñ٤ */
int
anthy_priv_dic_get_freq(void)
{
  struct word_line res;
  char *v;
  if (word_iterator.in_tt) {
    v = anthy_trie_find(anthy_private_tt_dic, word_iterator.key_buf);
    anthy_parse_word_line(v, &res);
    free(v);
  } else {
    anthy_parse_word_line(word_iterator.current_line, &res);
  }
  return res.freq;
}

/** 򤵤Ƥñʻ */
char *
anthy_priv_dic_get_wtype(char *buf, int len)
{
  struct word_line res;
  char *v;
  if (word_iterator.in_tt) {
    v = anthy_trie_find(anthy_private_tt_dic, word_iterator.key_buf);
    anthy_parse_word_line(v, &res);
    free(v);
  } else {
    anthy_parse_word_line(word_iterator.current_line, &res);
  }
  if (len - 1 < (int)strlen(res.wt)) {
    return NULL;
  }
  sprintf(buf, "%s", res.wt);
  return buf;
}

/** 򤵤Ƥñ */
char *
anthy_priv_dic_get_word(char *buf, int len)
{
  char *v;
  char *s;
  if (word_iterator.in_tt) {
    v = anthy_trie_find(anthy_private_tt_dic, word_iterator.key_buf);
  } else {
    v = word_iterator.current_line;
  }
  if (!v) {
    return NULL;
  }
  /* ʻθˤñФ */
  s = strchr(v, ' ');
  s++;
  if (!word_iterator.in_tt && dic_util_encoding == ANTHY_EUC_JP_ENCODING) {
    s = anthy_conv_utf8_to_euc(s);
    snprintf(buf, len, "%s", s);
    free(s);
  } else {
    snprintf(buf, len, "%s", s);
  }
  if (word_iterator.in_tt) {
    free(v);
  }
  return buf;
}

static int
dup_word_check(const char *v, const char *word, const char *wt)
{
  struct word_line res;

  anthy_parse_word_line(v, &res);

  /* ɤߤñӤ */
  if (!strcmp(res.wt, wt) &&
      !strcmp(res.word, word)) {
    return 1;
  }
  return 0;
}

static void
do_add_entry(const char *yomi, const char *word,
	     const char *wt_name, int freq)
{
  int i = 0, ok = 0;
  char *cur;
  char word_buf[256];
  char *idx_buf = malloc(strlen(yomi) + 12);
  do {
    sprintf(idx_buf, "%s%s %d", encoding_prefix(dic_util_encoding),
	    yomi, i);
    cur = anthy_trie_find(anthy_private_tt_dic, idx_buf);
    if (cur) {
      free(cur);
    } else {
      ok = 1;
    }
    i++;
  } while (!ok);
  sprintf(word_buf, "%s*%d %s", wt_name, freq, word);
  anthy_trie_add(anthy_private_tt_dic, idx_buf, word_buf);
  free(idx_buf);
}

static int
find_same_word(char *idx_buf, const char *yomi,
	       const char *word, const char *wt_name, int yomi_len)
{
  int found = 0;
  sprintf(idx_buf, "%s%s ",
	  encoding_prefix(dic_util_encoding),
	  yomi);
  anthy_trie_find_next_key(anthy_private_tt_dic,
			   idx_buf, yomi_len + 12);

  /* trieΥǥåõ */
  do {
    char *v;
    if (strncmp(&idx_buf[2], yomi, yomi_len) ||
	idx_buf[yomi_len+2] != ' ') {
      /* и줬ۤʤΤǥ롼׽λ */
      break;
    }
    /* texttrie˥ơиʳפƤ뤫å */
    v = anthy_trie_find(anthy_private_tt_dic, idx_buf);
    if (v) {
      found = dup_word_check(v, word, wt_name);
      free(v);
      if (found) {
	break;
      }
    }
  } while (anthy_trie_find_next_key(anthy_private_tt_dic,
				    idx_buf, yomi_len + 12));

  return found;
}

static int
find_cb(void *p, int next_offset, const char *key, const char *n)
{
  struct scan_context *sc = p;
  struct word_line res;
  if (strcmp(key, sc->yomi)) {
    sc->offset = next_offset;
    return 0;
  }
  anthy_parse_word_line(n, &res);
  if (!strcmp(res.wt, sc->wt_name) &&
      !strcmp(res.word, sc->word)) {
    sc->found_word = 1;
    return -1;
  }
  sc->offset = next_offset;
  return 0;
}

static int
order_cb(void *p, int next_offset, const char *key, const char *n)
{
  struct scan_context *sc = p;
  (void)n;
  if (strcmp(key, sc->yomi) >= 0) {
    sc->found_word = 1;
    return -1;
  }
  sc->offset = next_offset;
  return 0;
}

static int
do_add_word_to_textdict(struct textdict *td, int offset,
			const char *yomi, const char *word,
			const char *wt_name, int freq)
{
  char *buf = malloc(strlen(yomi) + strlen(word) + strlen(wt_name) + 20);
  int rv;
  if (!buf) {
    return -1;
  }
  sprintf(buf, "%s %s*%d %s\n", yomi, wt_name, freq, word);
  rv = anthy_textdict_insert_line(td, offset, buf);
  free(buf);
  return rv;
}

static int
add_word_to_textdict(const char *yomi, const char *word,
		     const char *wt_name, int freq)
{
  struct scan_context sc;
  int rv;
  sc.yomi = yomi;
  sc.word = word;
  sc.wt_name = wt_name;
  /* Ʊʪää */
  sc.offset = 0;
  sc.found_word = 0;
  anthy_textdict_scan(anthy_private_text_dic, 0, &sc,
		      find_cb);
  if (sc.found_word == 0) {
    anthy_textdict_delete_line(anthy_private_text_dic, sc.offset);
  }
  /* ɲäõ */
  sc.found_word = 0;
  anthy_textdict_scan(anthy_private_text_dic, 0, &sc,
		      order_cb);
  /* ɲä */
  rv = do_add_word_to_textdict(anthy_private_text_dic, sc.offset,
			       yomi, word, wt_name, freq);
  if (!rv) {
    return ANTHY_DIC_UTIL_OK;
  }
  return ANTHY_DIC_UTIL_ERROR;
}

/** ñϿ
 * ٤0ξϺ
 */
int
anthy_priv_dic_add_entry(const char *yomi, const char *word,
			 const char *wt_name, int freq)
{
  int yomi_len = strlen(yomi);
  char *idx_buf;
  int found = 0;
  int rv = ANTHY_DIC_UTIL_OK;

  if (yomi_len > MAX_KEY_LEN || yomi_len == 0) {
    return ANTHY_DIC_UTIL_ERROR;
  }

  if (wt_name[0] != '#') {
    return ANTHY_DIC_UTIL_ERROR;
  }

  if (dic_util_encoding == ANTHY_UTF8_ENCODING) {
    return add_word_to_textdict(yomi, word, wt_name, freq);
  }

  if (!anthy_private_tt_dic) {
    return ANTHY_DIC_UTIL_ERROR;
  }

  /* ƱФθ줬뤫å */
  idx_buf = malloc(yomi_len + 12);
  found = find_same_word(idx_buf, yomi, word, wt_name, yomi_len);

  if (freq > 0) {
    /* Ͽ */
    if (found) {
      /* ¸ΤΤ */
      anthy_trie_delete(anthy_private_tt_dic, idx_buf);
      rv = ANTHY_DIC_UTIL_DUPLICATE;
    }
    do_add_entry(yomi, word, wt_name, freq);
  } else if (found) {
    /* ٤ǤϤʤΤǡ */
    anthy_trie_delete(anthy_private_tt_dic, idx_buf);
  }
  free(idx_buf);
  return rv;
}

const char *
anthy_dic_util_get_anthydir(void)
{
  return anthy_conf_get_str("ANTHYDIR");
}

/* lookޥɤμ򸡺뤿δؿ */
static char *
do_search(FILE *fp, const char *word)
{
  char buf[32];
  char *res = NULL;
  int word_len = strlen(word);
  while (fgets(buf, 32, fp)) {
    int len = strlen(buf);
    buf[len - 1] = 0;
    len --;
    if (len > word_len) {
      continue;
    }
    if (!strncasecmp(buf, word, len)) {
      if (res) {
	free(res);
      }
      res = strdup(buf);
    }
  }
  return res;
}

/* lookޥɤμ򸡺API */
char *
anthy_dic_search_words_file(const char *word)
{
  FILE *fp;
  char *res;
  const char *words_dict_fn = anthy_conf_get_str("WORDS_FILE");
  if (!words_dict_fn) {
    return NULL;
  }
  fp = fopen(words_dict_fn, "r");
  if (!fp) {
    return NULL;
  }
  res = do_search(fp, word);
  fclose(fp);
  return res;
}
