package tk.eclipse.plugin.jseditor.editors.additional;

import java.util.ArrayList;
import java.util.List;

import tk.eclipse.plugin.htmleditor.HTMLPlugin;
import tk.eclipse.plugin.jseditor.editors.model.JavaScriptModel;

/**
 * <code>IAdditionalJavaScriptCompleter</code> implementation for
 * <strong>prototype.js</strong>.
 * 
 * @author Naoki Takezoe
 */
public class PrototypeCompleter extends AbstractCompleter {

	public List<JavaScriptModel> loadModel(List<JavaScriptModel> libModelList) {
		try {
			JsFileCache jsFileCache = getJsFileCache("js/prototype/1.7.0.0/prototype.js");
			String source = new String(jsFileCache.getBytes(), "UTF-8");
			JavaScriptModel model = new JavaScriptModel(jsFileCache.getFile(),
					source, libModelList);
			if (model != null) {
				libModelList.add(model);
				List<JavaScriptModel> list = new ArrayList<JavaScriptModel>();
				list.add(model);
				return list;
			}
		} catch (Exception e) {
			HTMLPlugin.logException(e);
		}
		return null;
	}
}