/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import tk.stepcounter.CountResult;
import tk.stepcounter.StepCounter;

public class PythonCounter
implements StepCounter {
    private static final String delim = "\"\"\"";

    public CountResult count(File file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long step = 0L;
        long non = 0L;
        long comment = 0L;
        boolean areaFlag = false;
        boolean objectStartingFlag = true;
        while ((line = reader.readLine()) != null) {
            String trimedLine = line.trim();
            if (areaFlag) {
                ++comment;
                if (!trimedLine.endsWith(delim)) continue;
                areaFlag = false;
                continue;
            }
            if (objectStartingFlag && trimedLine.startsWith(delim)) {
                ++comment;
                areaFlag = !trimedLine.endsWith(delim);
                continue;
            }
            objectStartingFlag = false;
            if (trimedLine.length() == 0) {
                ++non;
                continue;
            }
            if (trimedLine.indexOf(35) >= 0) {
                ++comment;
                continue;
            }
            ++step;
            if (!trimedLine.startsWith("def ") && !trimedLine.startsWith("class ")) continue;
            objectStartingFlag = true;
        }
        reader.close();
        return new CountResult(file.getName(), "py", step, non, comment);
    }
}

