/*
 * Decompiled with CFR 0.152.
 */
package tk.stepcounter;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import tk.stepcounter.AreaComment;
import tk.stepcounter.CountResult;
import tk.stepcounter.StepCounter;

public class DefaultStepCounter
implements StepCounter {
    private List lineComments = new ArrayList();
    private List areaComments = new ArrayList();
    private List skipPatterns = new ArrayList();
    private String fileType = "UNDEF";

    public void addSkipPattern(String pattern) {
        this.skipPatterns.add(pattern);
    }

    public String[] getSkipPatterns() {
        return this.skipPatterns.toArray(new String[this.skipPatterns.size()]);
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void addLineComment(String str) {
        this.lineComments.add(str);
    }

    public void addAreaComment(AreaComment area) {
        this.areaComments.add(area);
    }

    public CountResult count(File file) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        long step = 0L;
        long non = 0L;
        long comment = 0L;
        boolean areaFlag = false;
        AreaComment lastAreaComment = new AreaComment();
        while ((line = reader.readLine()) != null) {
            String trimedLine = line.trim();
            if (!areaFlag) {
                if (this.nonCheck(trimedLine)) {
                    ++non;
                    continue;
                }
                if (this.lineCommentCheck(trimedLine)) {
                    ++comment;
                    continue;
                }
                if (this.skipPatternCheck(trimedLine)) {
                    ++non;
                    continue;
                }
                lastAreaComment = this.areaCommentStartCheck(line);
                if (lastAreaComment != null) {
                    ++comment;
                    areaFlag = true;
                    continue;
                }
                ++step;
                continue;
            }
            ++comment;
            if (!this.areaCommentEndCheck(line, lastAreaComment)) continue;
            areaFlag = false;
        }
        reader.close();
        return new CountResult(file.getName(), this.getFileType(), step, non, comment);
    }

    private boolean skipPatternCheck(String line) {
        int i = 0;
        while (i < this.skipPatterns.size()) {
            if (Pattern.matches((String)this.skipPatterns.get(i), line)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean nonCheck(String line) {
        return line.equals("");
    }

    private boolean lineCommentCheck(String line) {
        int i = 0;
        while (i < this.lineComments.size()) {
            if (line.startsWith((String)this.lineComments.get(i))) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.areaComments.size()) {
            AreaComment area = (AreaComment)this.areaComments.get(i);
            String start = area.getStartString();
            String end = area.getEndString();
            int index = line.indexOf(start);
            if (index == 0 && line.indexOf(end, index) == line.length() - end.length()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private AreaComment areaCommentStartCheck(String line) {
        int i = 0;
        while (i < this.areaComments.size()) {
            AreaComment area = (AreaComment)this.areaComments.get(i);
            String start = area.getStartString();
            String end = area.getEndString();
            int index = line.indexOf(start);
            if (index >= 0 && line.indexOf(end, index) < 0) {
                return area;
            }
            ++i;
        }
        return null;
    }

    private boolean areaCommentEndCheck(String line, AreaComment area) {
        String end = area.getEndString();
        return line.indexOf(end) >= 0;
    }
}

