/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.wizards;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionValidator;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.wizards.StrutsWizardPage2;

public class StrutsWizardPage
extends WizardPage {
    private Button library;
    private Button tld;
    private Button strutsConfig;
    private Button message;
    private Button webXml;
    private Text containerText;
    private ISelection selection;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    private Text mapping;

    public StrutsWizardPage(ISelection selection) {
        super("wizardPage");
        this.setTitle(this.resource.getString("wizard.strutsSupport.title"));
        this.setDescription(this.resource.getString("wizard.strutsSupport.decription"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(this.resource.getString("wizard.label.webappRoot"));
        this.containerText = new Text(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrutsWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(container, 8);
        button.setText(this.resource.getString("wizard.label.browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StrutsWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(this.resource.getString("wizard.label.mapping"));
        this.mapping = new Text(container, 2048);
        this.mapping.setLayoutData((Object)new GridData(768));
        this.mapping.setText("*.do");
        this.mapping.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StrutsWizardPage.this.dialogChanged();
            }
        });
        label = new Label(container, 0);
        this.library = new Button(container, 32);
        this.library.setText(this.resource.getString("wizard.label.addStrutsLibrary"));
        this.library.setSelection(true);
        this.library.setLayoutData((Object)this.createCheckBoxGridData());
        this.tld = new Button(container, 32);
        this.tld.setText(this.resource.getString("wizard.label.addStrutsTLD"));
        this.tld.setSelection(true);
        this.tld.setLayoutData((Object)this.createCheckBoxGridData());
        this.strutsConfig = new Button(container, 32);
        this.strutsConfig.setText(this.resource.getString("wizard.label.createStrutsConfig"));
        this.strutsConfig.setSelection(true);
        this.strutsConfig.setLayoutData((Object)this.createCheckBoxGridData());
        this.strutsConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                StrutsWizardPage2 page2 = (StrutsWizardPage2)StrutsWizardPage.this.getWizard().getNextPage((IWizardPage)StrutsWizardPage.this);
                page2.setEnabled(StrutsWizardPage.this.strutsConfig.getSelection());
            }
        });
        this.message = new Button(container, 32);
        this.message.setText(this.resource.getString("wizard.label.createMessageResources"));
        this.message.setSelection(true);
        this.message.setLayoutData((Object)this.createCheckBoxGridData());
        this.webXml = new Button(container, 32);
        this.webXml.setText(this.resource.getString("wizard.label.createWebXML"));
        this.webXml.setSelection(true);
        this.webXml.setLayoutData((Object)this.createCheckBoxGridData());
        this.webXml.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                StrutsWizardPage.this.mapping.setEnabled(StrutsWizardPage.this.webXml.getSelection());
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)container);
    }

    private GridData createCheckBoxGridData() {
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        return gd;
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)this.selection;
            if (ssel.size() > 1) {
                return;
            }
            Object obj = ssel.getFirstElement();
            if (obj instanceof IJavaProject) {
                this.containerText.setText(((IJavaProject)obj).getProject().getFullPath().toString());
            } else if (obj instanceof IJavaElement) {
                this.containerText.setText(((IJavaElement)obj).getJavaProject().getProject().getFullPath().toString());
            } else if (obj instanceof IProject) {
                this.containerText.setText(((IProject)obj).getFullPath().toString());
            } else if (obj instanceof IFolder) {
                this.containerText.setText(((IFolder)obj).getFullPath().toString());
            } else if (obj instanceof IFile) {
                this.containerText.setText(((IFile)obj).getParent().getFullPath().toString());
            }
        }
    }

    private void handleBrowse() {
        Object[] result;
        IWorkspaceRoot root;
        IResource resource;
        IWorkspaceRoot initial = null;
        if (this.containerText.getText().length() > 0 && (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember(this.containerText.getText())) != null && resource.exists() && resource instanceof IContainer) {
            initial = (IContainer)resource;
        }
        if (initial == null) {
            initial = ResourcesPlugin.getWorkspace().getRoot();
        }
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)initial, false, this.resource.getString("wizard.message.selectWebAppRoot"));
        dialog.setValidator(new ISelectionValidator(){

            public String isValid(Object selection) {
                block3: {
                    try {
                        IWorkspaceRoot root;
                        IResource resource;
                        if (selection == null || (resource = (root = ResourcesPlugin.getWorkspace().getRoot()).findMember((IPath)selection)) == null || !resource.getProject().hasNature("org.eclipse.jdt.core.javanature")) break block3;
                        return null;
                    }
                    catch (Exception ex) {
                        return ex.toString();
                    }
                }
                return StrutsWizardPage.this.resource.getString("error.noJavaProject");
            }
        });
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.containerText.setText(result[0].toString());
        }
    }

    private void dialogChanged() {
        String container = this.getWebAppRoot();
        if (container.length() == 0) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.required"), new String[]{this.resource.getString("message.project")}));
            return;
        }
        if (this.mapping.getText().length() == 0) {
            this.updateStatus(Util.createMessage(this.resource.getString("error.required"), new String[]{this.resource.getString("message.mapping")}));
            return;
        }
        this.updateStatus(null);
    }

    public String getWebAppRoot() {
        return this.containerText.getText();
    }

    public boolean getCreateStrutsConfigXML() {
        return this.strutsConfig.getSelection();
    }

    public boolean getCreateWebXML() {
        return this.webXml.getSelection();
    }

    public boolean getAddStrutsLibraries() {
        return this.library.getSelection();
    }

    public boolean getAddTLDFiles() {
        return this.tld.getSelection();
    }

    public boolean getCreateMessageResources() {
        return this.message.getSelection();
    }

    public String getMapping() {
        return this.mapping.getText();
    }

    private void updateStatus(String message) {
        this.setMessage(message, 3);
        this.setPageComplete(message == null);
    }
}

