/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.validator;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import tk.eclipse.plugin.struts.StrutsProject;
import tk.eclipse.plugin.struts.validator.StrutsConfigValidator;
import tk.eclipse.plugin.struts.validator.TilesValidator;
import tk.eclipse.plugin.struts.validator.ValidatorValidator;

public class StrutsProjectBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IResourceDelta delta = this.getDelta(project);
        if (delta == null) {
            return null;
        }
        StrutsProject strutsProject = new StrutsProject(project);
        if (this.processDelta(delta)) {
            this.validateStrutsConfig(strutsProject);
            this.validateTiles(strutsProject);
            this.validateValidator(strutsProject);
        }
        this.getProject().refreshLocal(2, monitor);
        return null;
    }

    private boolean processDelta(IResourceDelta delta) {
        String path;
        if (delta.getKind() != 0 && ((path = delta.getProjectRelativePath().toString()).endsWith(".jsp") || path.endsWith(".java") || path.endsWith(".class") || path.endsWith(".xml") || path.endsWith(".project") || path.endsWith(".classpath"))) {
            return true;
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        if (i < children.length) {
            return this.processDelta(children[i]);
        }
        return false;
    }

    private void validateStrutsConfig(StrutsProject project) {
        String[] modules = project.getModuleNames();
        int i = 0;
        while (i < modules.length) {
            IFile[] files = project.getStrutsConfigXML(modules[i]);
            int j = 0;
            while (j < files.length) {
                new StrutsConfigValidator(project, files[j], modules[i]).doValidate();
                ++j;
            }
            ++i;
        }
    }

    private void validateTiles(StrutsProject project) {
        String[] modules = project.getModuleNames();
        int i = 0;
        while (i < modules.length) {
            IFile[] files = project.getTilesXML(modules[i]);
            int j = 0;
            while (j < files.length) {
                new TilesValidator(project, files[j], modules[i]).doValidate();
                ++j;
            }
            ++i;
        }
    }

    private void validateValidator(StrutsProject project) {
        String[] modules = project.getModuleNames();
        int i = 0;
        while (i < modules.length) {
            IFile[] files = project.getValidatorXML(modules[i]);
            int j = 0;
            while (j < files.length) {
                new ValidatorValidator(project, files[j], modules[i]).doValidate();
                ++j;
            }
            ++i;
        }
    }
}

