/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.models;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import tk.eclipse.plugin.struts.StrutsConfigRefactor;
import tk.eclipse.plugin.struts.editors.models.AbstractConnectionModel;
import tk.eclipse.plugin.struts.editors.models.AbstractEntityModel;
import tk.eclipse.plugin.struts.editors.models.DirectForwardModel;
import tk.eclipse.plugin.struts.editors.models.ExceptionModel;
import tk.eclipse.plugin.struts.editors.models.ForwardModel;
import tk.eclipse.plugin.struts.editors.models.IncludeModel;
import tk.eclipse.plugin.struts.editors.models.InputModel;
import tk.eclipse.plugin.struts.editors.models.TilesAttributeModel;
import tk.eclipse.plugin.struts.editors.models.TilesDefinitionModel;
import tk.eclipse.plugin.struts.editors.models.TilesRootModel;

public class PageModel
extends AbstractEntityModel {
    private static final long serialVersionUID = -8496733268861330331L;
    private String path = "";
    private String moduleName = "";
    public static final String P_PATH = "_path";
    public static final String P_TILES_PATH = "_tiles_path";
    public static final String P_TILES_ATTR_PREFIX = "_tiles_attr_";

    protected boolean hasComment() {
        return false;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setPath(String path) {
        if (!path.equals("/") && !path.startsWith("/") && path.indexOf(".jsp") != -1) {
            path = "/" + path;
        }
        StrutsConfigRefactor.changePath(this.getRoot(), this.path, path);
        this.path = path;
        this.firePropertyChange(P_PATH, null, path);
    }

    public String getPath() {
        return this.path;
    }

    public boolean isTile() {
        TilesRootModel tilesRoot = this.getRoot().getTilesRoot();
        return tilesRoot != null && tilesRoot.getDefinition(this.path) != null;
    }

    public String[] getPaths() {
        TilesDefinitionModel definition;
        TilesRootModel tilesRoot = this.getRoot().getTilesRoot();
        if (tilesRoot != null && (definition = tilesRoot.getDefinition(this.path)) != null) {
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(definition.getPath(true));
            Map attributes = definition.getAttributes(true);
            Iterator it = attributes.values().iterator();
            while (it.hasNext()) {
                TilesAttributeModel attr = (TilesAttributeModel)it.next();
                if (!attr.isPageOrTemplate()) continue;
                paths.add(attr.getValue());
            }
            return paths.toArray(new String[paths.size()]);
        }
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        TilesDefinitionModel definition;
        TilesRootModel tilesRoot = this.getRoot().getTilesRoot();
        if (tilesRoot != null && (definition = tilesRoot.getDefinition(this.path)) != null) {
            Map attributes = definition.getAttributes(true);
            IPropertyDescriptor[] descriptors = new IPropertyDescriptor[2 + attributes.size()];
            descriptors[0] = new TextPropertyDescriptor((Object)P_PATH, "path");
            descriptors[1] = new PropertyDescriptor((Object)P_TILES_PATH, "tile path");
            Iterator it = attributes.values().iterator();
            int i = 2;
            while (it.hasNext()) {
                TilesAttributeModel attr = (TilesAttributeModel)it.next();
                descriptors[i] = new PropertyDescriptor((Object)(P_TILES_ATTR_PREFIX + attr.getName()), "tile attribute: " + attr.getName());
                ++i;
            }
            return descriptors;
        }
        return new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)P_PATH, "path")};
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(P_PATH)) {
            return this.getPath();
        }
        if (id.equals(P_TILES_PATH)) {
            return this.getRoot().getTilesRoot().getDefinition(this.path).getPath(true);
        }
        if (id instanceof String && ((String)id).startsWith(P_TILES_ATTR_PREFIX)) {
            return this.getRoot().getTilesRoot().getDefinition(this.path).getAttribute(((String)id).substring(P_TILES_ATTR_PREFIX.length()), true).getValue();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return id.equals(P_PATH);
    }

    public void setPropertyValue(Object id, Object value) {
        if (id.equals(P_PATH)) {
            this.setPath((String)value);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof PageModel && ((PageModel)obj).getPath().equals(this.getPath());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("page");
        sb.append(" path=" + this.getPath());
        return sb.toString();
    }

    public boolean canSource(AbstractConnectionModel conn) {
        return conn instanceof InputModel;
    }

    public boolean canTarget(AbstractConnectionModel conn) {
        if (conn instanceof ForwardModel || conn instanceof ExceptionModel) {
            return true;
        }
        return conn instanceof DirectForwardModel || conn instanceof IncludeModel;
    }
}

