/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.editors.editparts;

import java.beans.PropertyChangeEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.editparts.AbstractEntityEditPart;
import tk.eclipse.plugin.struts.editors.models.ActionModel;

public class ActionEditPart
extends AbstractEntityEditPart {
    private ActionDirectEditManager directManager = null;
    static /* synthetic */ Class class$0;

    public ActionEditPart(IFile file) {
        super(file);
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ActionDirectEditPolicy());
    }

    protected IFigure createFigure() {
        ActionModel model = (ActionModel)this.getModel();
        String path = model.getPath();
        if (path.equals("")) {
            path = "<action>";
        }
        Label label = new Label();
        label.setText(path);
        if (this.isValid()) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action_warn"));
        }
        label.setTextPlacement(4);
        return label;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        Label label = (Label)this.getFigure();
        if (this.isValid()) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action_warn"));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String propName = evt.getPropertyName();
        Label label = (Label)this.getFigure();
        if (propName.equals("_path")) {
            String path = (String)evt.getNewValue();
            if (path.equals("")) {
                path = "<action>";
            }
            label.setText(path);
        }
        if (this.isValid()) {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action"));
        } else {
            label.setIcon(StrutsPlugin.getDefault().getImage("__image_action_warn"));
        }
    }

    protected boolean isValid() {
        ActionModel model = (ActionModel)this.getModel();
        boolean valid = false;
        String type = model.getType();
        String forward = model.getForward();
        String include = model.getInclude();
        if (type != null && !type.equals("")) {
            valid = !(!this.exists(type) || forward != null && !forward.equals("") || include != null && !include.equals(""));
        } else if (forward != null && !forward.equals("")) {
            valid = include == null || include.equals("");
        } else if (include != null && !include.equals("")) {
            valid = true;
        }
        return valid;
    }

    public boolean exists(String className) {
        block7: {
            block6: {
                if (className != null && !className.equals("")) break block6;
                return false;
            }
            if (className.indexOf(123) < 0) break block7;
            return true;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.getFile().getProject());
            IType type = javaProject.findType(className);
            if (type.isClass() && type.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void performRequest(Request req) {
        if (req.getType().equals("direct edit")) {
            this.performDirectEdit();
            return;
        }
        if (req.getType().equals("open")) {
            this.performOpen();
            return;
        }
        super.performRequest(req);
    }

    private void performOpen() {
        Util.openAction(this.getFile().getProject(), (ActionModel)this.getModel());
    }

    private void performDirectEdit() {
        if (this.directManager == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.viewers.TextCellEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.directManager = new ActionDirectEditManager(clazz, new ActionCellEditorLocator(this.getFigure()));
        }
        this.directManager.show();
    }

    private class ActionDirectEditManager
    extends DirectEditManager {
        public ActionDirectEditManager(Class editorType, CellEditorLocator locator) {
            super((GraphicalEditPart)ActionEditPart.this, editorType, locator);
        }

        protected void initCellEditor() {
            this.getCellEditor().setValue((Object)((ActionModel)ActionEditPart.this.getModel()).getPath());
            Text text = (Text)this.getCellEditor().getControl();
            text.selectAll();
        }
    }

    private class ActionCellEditorLocator
    implements CellEditorLocator {
        private IFigure figure;

        public ActionCellEditorLocator(IFigure f) {
            this.figure = f;
        }

        public void relocate(CellEditor celleditor) {
            Text text = (Text)celleditor.getControl();
            Rectangle rect = this.figure.getBounds().getCopy();
            this.figure.translateToAbsolute((Translatable)rect);
            text.setBounds(rect.x, rect.y + 32, rect.width, rect.height - 32);
        }
    }

    private class DirectEditCommand
    extends Command {
        private String oldPath;
        private String newPath;

        private DirectEditCommand() {
        }

        public void execute() {
            ActionModel model = (ActionModel)ActionEditPart.this.getModel();
            this.oldPath = model.getPath();
            model.setPath(this.newPath);
        }

        public void setPath(String path) {
            this.newPath = path;
        }

        public void undo() {
            ActionModel model = (ActionModel)ActionEditPart.this.getModel();
            model.setPath(this.oldPath);
        }
    }

    private class ActionDirectEditPolicy
    extends DirectEditPolicy {
        private ActionDirectEditPolicy() {
        }

        protected Command getDirectEditCommand(DirectEditRequest request) {
            DirectEditCommand command = new DirectEditCommand();
            command.setPath((String)request.getCellEditor().getValue());
            return command;
        }

        protected void showCurrentEditValue(DirectEditRequest request) {
        }
    }
}

