package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.OutputTextModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:outputText.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.OutputTextModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class OutputTextLoader extends AbstractElementLoader {

	protected AbstractJSFModel loadModel(FuzzyXMLElement element) {
		OutputTextModel model = new OutputTextModel();
		model.setValue(getString(element, "value"));
		
		String color = getStyle(element, "color");
		if(color!=null){
			model.setColor(HTMLUtil.toRGB(color));
		}
		
		String fontSize = getStyle(element, "font-size");
		if(fontSize!=null){
			model.setSize(fontSize);
		}
		
		return model;
	}

}
