package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.InputTextModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for h:inputText.
 * <p>
 * This loader assembles {@link tk.eclipse.plugin.visualjsf.models.InputTextModel}
 * from corresponded JSF tags.
 * 
 * @author Naoki Takezoe
 */
public class InputTextLoader extends AbstractFormElementLoader {

	public AbstractJSFModel loadModel(FuzzyXMLElement element) {
		InputTextModel model = new InputTextModel();
		
		model.setValue(getString(element, "value"));
		model.setRequired(getBoolean(element, "required"));
		model.setValueChangeListener(getString(element, "valueChangeListener"));
		
		return model;
	}

}
