package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFSelectModel;

/**
 * The {@link tk.eclipse.plugin.visualjsf.loader.IElementLoader} implementation
 * for models which have f:selectItem / f:selectItems as their children.
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractSelectElementLoader extends AbstractFormElementLoader {
	
	protected void setItems(AbstractJSFSelectModel model, FuzzyXMLElement element) {
		
		FuzzyXMLNode[] children = element.getChildren();
		for(int i=0;i<children.length;i++){
			if(children[i] instanceof FuzzyXMLElement){
				FuzzyXMLElement e = (FuzzyXMLElement)children[i];
				if(e.getName().equals("f:selectItems")){
					model.setSelectItems(getString(e, "value"));
					model.getSelectItem().clear();
					break;
				} else if(e.getName().equals("f:selectItem")){
					String[] item = new String[]{
							getString(e, "itemLabel"),
							getString(e, "itemValue")
					};
					model.getSelectItem().add(item);
				}
			}
		}
	}

	
}
