package tk.eclipse.plugin.visualjsf.loader;

import jp.aonir.fuzzyxml.FuzzyXMLElement;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFFormModel;
import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;

/**
 * 
 * @author Naoki Takezoe
 */
public abstract class AbstractFormElementLoader extends AbstractElementLoader {
	
	public AbstractJSFModel load(FuzzyXMLElement element){
		AbstractJSFFormModel model = 
			(AbstractJSFFormModel)super.load(element);
		
		model.setOnBlur(getString(element, "onblur"));
		model.setOnChange(getString(element, "onchange"));
		model.setOnClick(getString(element, "onclick"));
		model.setOnDbClick(getString(element, "ondbclick"));
		model.setOnFocus(getString(element, "onfocus"));
		model.setOnKeyDown(getString(element, "onkeydown"));
		model.setOnKeyPress(getString(element, "onkeypress"));
		model.setOnKeyUp(getString(element, "onkeyup"));
		model.setOnMouseDown(getString(element, "onmousedown"));
		model.setOnMouseMove(getString(element, "onmousemove"));
		model.setOnMouseOut(getString(element, "onmouseout"));
		model.setOnMouseOver(getString(element, "onmouseover"));
		model.setOnMouseUp(getString(element, "onmouseup"));
		model.setOnSelect(getString(element, "onselect"));
		model.setDisabled(getBoolean(element, "disabled"));
		model.setReadonly(getBoolean(element, "readonly"));
		model.setTabIndex(getString(element, "tabindex"));
		
		return model;
	}

}
