/**
 * 
 */
package tk.eclipse.plugin.visualjsf.figures;

import java.io.IOException;
import java.io.InputStream;

import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.swt.graphics.Image;

/**
 * @author Takahiro Shida
 */
public class RadioButton extends Label {

	private boolean checked = false;
	
	static final Image
		UNCHECKED = createImage("radio_unselected.gif"), //$NON-NLS-1$
		CHECKED = createImage("radio_selected.gif"); //$NON-NLS-1$

	private static Image createImage(String name) {
		InputStream stream = RadioButton.class.getResourceAsStream(name);
		Image image = new Image(null, stream);
		try {
			stream.close();
		} catch (IOException ioe) {
		}
		return image;
	}

	public RadioButton() {
		this(""); //$NON-NLS-1$
	}

	public RadioButton(String text) {
		super(text, UNCHECKED);
		setTextPlacement(PositionConstants.EAST);
		setLabelAlignment(Label.LEFT);
	}
	
	public void setChecked(boolean checked){
		this.checked = checked;
		setIcon(checked ? CHECKED : UNCHECKED);
	}
	
	public boolean isChecked(){
		return this.checked;
	}

}
