package tk.eclipse.plugin.visualjsf.editparts;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

import tk.eclipse.plugin.visualjsf.models.AbstractJSFModel;
import tk.eclipse.plugin.visualjsf.models.AbstractModel;
import tk.eclipse.plugin.visualjsf.models.RootModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.RootModel}.
 * 
 * @author Naoki Takezoe
 */
public class RootEditPart extends AbstractEditPart {
	
	protected IFigure createFigure() {
		Layer figure = new Layer(){
			protected void paintFigure(Graphics graphics) {
				graphics.setForegroundColor(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
				for(int x=10;x<getSize().width;x=x+10){
					for(int y=10;y<getSize().height;y=y+10){
						graphics.drawPoint(x, y);
					}
				}
			}
		};
		figure.setLayoutManager(new XYLayout());
		return figure;
	}
	
	protected void createEditPolicies() {
		installEditPolicy(EditPolicy.LAYOUT_ROLE, new RootEditPolicy());
	}
	
	protected List getModelChildren() {
		List list = ((RootModel)getModel()).getChildren();
		ArrayList models = new ArrayList();
		for(int i=0;i<list.size();i++){
			Object obj = list.get(i);
			if(obj instanceof AbstractModel){
				models.add(obj);
			}
		}
		return models;
	}
	
	public void propertyChange(PropertyChangeEvent evt) {
		if (evt.getPropertyName().equals(RootModel.P_CHILDREN)) {
			refreshChildren();
		}
		refreshVisuals();
	}
	
	/** EditPolicy for layout */
	private class RootEditPolicy extends XYLayoutEditPolicy {
		
		protected EditPolicy createChildEditPolicy(EditPart child) {
			return new ResizableEditPolicy(){
				protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
					IFigure feedback = getDragSourceFeedbackFigure();
					
					PrecisionRectangle rect = new PrecisionRectangle(getInitialFeedbackBounds().getCopy());
					getHostFigure().translateToAbsolute(rect);
					rect.translate(request.getMoveDelta());
					rect.resize(request.getSizeDelta());
					snapToGrid(rect);
					
					feedback.translateToRelative(rect);
					feedback.setBounds(rect);
				}				
			};
		}
		
		protected void showSizeOnDropFeedback(CreateRequest request) {	
			Point p = new Point(request.getLocation().getCopy());
			IFigure feedback = getSizeOnDropFeedback(request);
			feedback.translateToRelative(p);
			Dimension size = request.getSize().getCopy();
			feedback.translateToRelative(size);
			
			Rectangle rectangle = new Rectangle(p, size).expand(getCreationFeedbackOffset(request));
			snapToGrid(rectangle);
			
			feedback.setBounds(rectangle);
		}		
		
		protected Command createAddCommand(EditPart child, Object constraint) {
			return null;
		}
		
		protected Command createChangeConstraintCommand(EditPart child,Object constraint) {
			Rectangle rectangle = (Rectangle)constraint;
			snapToGrid(rectangle);
			
			ChangeConstraintCommand command = new ChangeConstraintCommand();
			command.setModel((AbstractJSFModel)child.getModel());
			command.setConstraint(rectangle);
			return command;
		}
		
		protected Command getCreateCommand(CreateRequest request) {
			CreateCommand command = new CreateCommand();
			Rectangle constraint = (Rectangle) getConstraintFor(request);
			snapToGrid(constraint);
			
			AbstractJSFModel model = (AbstractJSFModel) request.getNewObject();
			model.setConstraint(constraint);
			
			command.setRootModel(getHost().getModel());
			command.setModel(model);
			return command;
		}
		
		protected Command getDeleteDependantCommand(Request request) {
			return null;
		}
		
		private void snapToGrid(Rectangle rectangle){
			rectangle.x = roundValue(rectangle.x);
			rectangle.y = roundValue(rectangle.y);
			rectangle.width = roundValue(rectangle.width);
			rectangle.height = roundValue(rectangle.height);
		}
		
		private int roundValue(int value){
			int div = value % 10;
			if(div >= 5){
				return value + (10 - div);
			} else {
				return value - div;
			}
		}
	}
	
	/** Change constraint command */
	private class ChangeConstraintCommand extends Command {
		
		private AbstractJSFModel model;
		private Rectangle constraint;
		private Rectangle oldConstraint;
		
		public void execute(){
			model.setConstraint(constraint);
		}
		
		public void setConstraint(Rectangle constraint){
			this.constraint = constraint;
		}
		
		public void setModel(AbstractJSFModel model){
			this.model = model;
			oldConstraint = model.getConstraint();
		}
		
		public void undo() {
			model.setConstraint(oldConstraint);
		}
	}
	
	/** Creation model command */
	private class CreateCommand extends Command {
		
		private RootModel root;
		private AbstractJSFModel model;
		
		public void execute() {
			root.addChild(model);
		}
		
		public void setRootModel(Object root) {
			this.root = (RootModel)root;
		}
		
		public void setModel(Object model) {
			this.model = (AbstractJSFModel) model;
		}
		
		public void undo() {
			root.removeChild(model);
		}
	}
}
