package tk.eclipse.plugin.visualjsf.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.IAction;

import tk.eclipse.plugin.visualjsf.figures.Text;
import tk.eclipse.plugin.visualjsf.models.InputSecretModel;
import tk.eclipse.plugin.visualjsf.models.InputTextModel;

/**
 * The editpart for {@link tk.eclipse.plugin.visualjsf.models.InputSecretModel}.
 * 
 * @author Naoki Takezoe
 */
public class InputSecretEditPart extends AbstractJSFEditPart {

	protected IFigure createFigure() {
		InputTextModel model = (InputTextModel)getModel();
		Text text = new Text(getSecretText(model.getValue()));
		return text;
	}
	
	protected void refreshVisuals() {
		super.refreshVisuals();
		
		InputTextModel model = (InputTextModel)getModel();
		Text text = (Text)getFigure();
		text.setText(getSecretText(model.getValue()));
		text.repaint();
	}
	
	private String getSecretText(String text){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<text.length();i++){
			sb.append("*");
		}
		return sb.toString();
	}
	
	/* (non-Javadoc)
	 * @see tk.eclipse.plugin.visualjsf.editparts.AbstractEditPart#getMenuActions()
	 */
	public IAction[] getMenuActions() {
		InputSecretModel model = (InputSecretModel)getModel();
		return new IAction[]{
				createValueChangeListenerAction("inputSecret_valueChangeListener", 
						model.getName())
		};
	}

	
}
