/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.validator;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.XPath;
import org.apache.commons.el.parser.ELParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.Converter;
import tk.eclipse.plugin.jsf.JSFAttributeAssist;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.JSFProject;
import tk.eclipse.plugin.jsf.JSFTagDefinition;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.Validator;
import tk.eclipse.plugin.jspeditor.editors.JSPInfo;
import tk.eclipse.plugin.jspeditor.editors.JSPValidator;
import tk.eclipse.plugin.jspeditor.editors.TLDInfo;

public class FacesJSPValidator {
    private JSFProject project;
    private IFile file;
    private JSPInfo info;
    private String contents;
    private FuzzyXMLDocument doc;
    private String htmlPrefix;
    private String corePrefix;
    private String myfacesPrefix;
    private String tomahawkPrefix;

    public FacesJSPValidator(JSFProject project, IFile file) {
        this.project = project;
        this.file = file;
        try {
            this.contents = new String(HTMLUtil.readStream((InputStream)file.getContents()));
            this.info = JSPInfo.getJSPInfo((IFile)file, (String)this.contents);
            TLDInfo[] tlds = this.info.getTLDInfo();
            int i = 0;
            while (i < tlds.length) {
                if (tlds[i].getTaglibUri() != null) {
                    if (tlds[i].getTaglibUri().equals("http://java.sun.com/jsf/core")) {
                        this.corePrefix = tlds[i].getPrefix();
                    } else if (tlds[i].getTaglibUri().equals("http://java.sun.com/jsf/html")) {
                        this.htmlPrefix = tlds[i].getPrefix();
                    } else if (tlds[i].getTaglibUri().equals("http://myfaces.sourceforge.net/tld/myfaces_ext_0_9.tld")) {
                        this.myfacesPrefix = tlds[i].getPrefix();
                    } else if (tlds[i].getTaglibUri().equals("http://myfaces.apache.org/extensions")) {
                        this.myfacesPrefix = tlds[i].getPrefix();
                    } else if (tlds[i].getTaglibUri().equals("http://myfaces.apache.org/tomahawk")) {
                        this.tomahawkPrefix = tlds[i].getPrefix();
                    }
                }
                ++i;
            }
            this.contents = this.contents.replaceAll("\r\n", " \n");
            this.contents = this.contents.replaceAll("\r", "\n");
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
    }

    public void doValidate() {
        try {
            this.removeMaker((IResource)this.file);
            new JSPValidator(this.file, this.info).doValidate();
            this.doc = this.info.getDocument();
            if (this.doc == null) {
                return;
            }
            FuzzyXMLElement root = this.doc.getDocumentElement();
            FuzzyXMLElement element = (FuzzyXMLElement)XPath.selectSingleNode((FuzzyXMLElement)root, (String)"*");
            if (element != null) {
                this.validateElement(element);
            }
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
    }

    private boolean isValidationTargetElement(String tagName) {
        if (this.htmlPrefix != null && tagName.startsWith(String.valueOf(this.htmlPrefix) + ":")) {
            return true;
        }
        if (this.corePrefix != null && tagName.startsWith(String.valueOf(this.corePrefix) + ":")) {
            return true;
        }
        if (this.myfacesPrefix != null && tagName.startsWith(String.valueOf(this.myfacesPrefix) + ":")) {
            return true;
        }
        return this.tomahawkPrefix != null && tagName.startsWith(String.valueOf(this.tomahawkPrefix) + ":");
    }

    private void validateElement(FuzzyXMLElement element) throws CoreException {
        String[] names;
        String name = element.getName();
        if (this.isValidationTargetElement(name) && (names = name.split(":")).length > 1) {
            FuzzyXMLAttribute[] attrs = element.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                block19: {
                    String attrName = attrs[i].getName();
                    String attrValue = attrs[i].getValue();
                    if (names[1].equals("converter") && attrName.equals("converterId") || attrName.equals("converter")) {
                        this.validateConverter(attrs[i], attrValue);
                    } else if (names[1].equals("validator") && attrName.equals("validatorId")) {
                        this.validateValidator(attrs[i], attrValue);
                    } else {
                        String type = JSFTagDefinition.getAttributeInfo(names[1], attrName);
                        if (type != null && attrValue.startsWith("#{")) {
                            if (!(attrValue = attrValue.substring(2)).endsWith("}")) {
                                this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.requireClose", attrs[i].getName()));
                            } else {
                                attrValue = attrValue.substring(0, attrValue.length() - 1);
                                if (type == "value") {
                                    String el = "${" + attrValue + "}";
                                    try {
                                        ELParser parser = new ELParser((Reader)new StringReader(el));
                                        parser.ExpressionString();
                                    }
                                    catch (Exception ex) {
                                        this.createAttributeValueMarker(attrs[i], this.createMessage("validation.message.invalidEL", attrValue));
                                        break block19;
                                    }
                                    StringBuffer sb = new StringBuffer();
                                    boolean errorFlag = true;
                                    int j = 0;
                                    while (j < attrValue.length()) {
                                        char c = attrValue.charAt(j);
                                        if (Character.isJavaIdentifierPart(c) || c == '.') {
                                            sb.append(c);
                                        } else {
                                            errorFlag = this.validateBinding(element, attrs[i], sb.toString(), "prop");
                                            sb.setLength(0);
                                            if (!errorFlag) break;
                                        }
                                        ++j;
                                    }
                                    if (errorFlag && sb.length() > 0) {
                                        this.validateBinding(element, attrs[i], sb.toString(), "prop");
                                    }
                                } else {
                                    this.validateBinding(element, attrs[i], attrValue, type);
                                }
                            }
                        }
                    }
                }
                ++i;
            }
        }
        FuzzyXMLNode[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof FuzzyXMLElement) {
                this.validateElement((FuzzyXMLElement)children[i]);
            }
            ++i;
        }
    }

    private void validateValidator(FuzzyXMLAttribute attr, String value) throws CoreException {
        Validator[] validators = this.project.getValidators();
        boolean found = false;
        int i = 0;
        while (i < validators.length) {
            if (validators[i].getValidatorId().equals(value)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.createAttributeValueMarker(attr, this.createMessage("validation.message.notDefined", value));
        }
    }

    private void validateConverter(FuzzyXMLAttribute attr, String value) throws CoreException {
        Converter[] converters = this.project.getConverters();
        boolean found = false;
        int i = 0;
        while (i < converters.length) {
            if (converters[i].getConverterId().equals(value)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            this.createAttributeValueMarker(attr, this.createMessage("validation.message.notDefined", value));
        }
    }

    private boolean validateBinding(FuzzyXMLElement element, FuzzyXMLAttribute attr, String value, String type) throws CoreException {
        value = value.trim();
        int i = 0;
        while (i < JSFAttributeAssist.IMPLICIT_OBJECTS.length) {
            if (value.startsWith(JSFAttributeAssist.IMPLICIT_OBJECTS[i])) {
                return true;
            }
            ++i;
        }
        String[] dim = Util.splitManagedBean(value);
        ManagedBean bean = Util.evalPropertyBinding(dim, this.project);
        if (value.indexOf(46) > 0 && dim.length == 1) {
            this.createAttributeValueMarker(attr, JSFPlugin.getResourceString("validation.message.notSpecified"));
            return false;
        }
        if (bean == null && value.indexOf(46) > 0) {
            if (this.existsVariableDefinedByParents(element, dim[0])) {
                return true;
            }
            this.createAttributeValueMarker(attr, this.createMessage("validation.message.notDefined", value));
            return false;
        }
        if (dim.length == 1 || bean == null) {
            return true;
        }
        if (type == "action") {
            if (!bean.hasActionMethod(dim[dim.length - 1])) {
                this.createAttributeValueMarker(attr, this.createMessage("validation.message.notDefined", value));
                return false;
            }
        } else if (type == "actionListener") {
            if (!bean.hasActionListenerMethod(dim[dim.length - 1])) {
                this.createAttributeValueMarker(attr, this.createMessage("validation.message.notDefined", value));
                return false;
            }
        } else if (type == "valudaChangeListener") {
            if (!bean.hasValueChangeListenerMethod(dim[dim.length - 1])) {
                this.createAttributeValueMarker(attr, this.createMessage("validation.message.notDefined", value));
                return false;
            }
        } else if (type == "validater") {
            if (!bean.hasValidaterMethod(dim[dim.length - 1])) {
                this.createAttributeValueMarker(attr, this.createMessage("validation.message.notDefined", value));
                return false;
            }
        } else if (type == "prop" && !bean.hasProperty(dim[dim.length - 1])) {
            this.createAttributeValueMarker(attr, this.createMessage("validation.message.notDefined", value));
            return false;
        }
        return true;
    }

    private boolean existsVariableDefinedByParents(FuzzyXMLElement element, String var) {
        while (element.getParentNode() != null) {
            FuzzyXMLAttribute attr;
            FuzzyXMLNode node = element.getParentNode();
            if (!(node instanceof FuzzyXMLElement)) break;
            element = (FuzzyXMLElement)node;
            if (element.getName().equals(String.valueOf(this.htmlPrefix) + ":dataTable") && (attr = element.getAttributeNode("var")) != null && attr.getValue().equals(var)) {
                return true;
            }
            if (element.getName().equals(String.valueOf(this.myfacesPrefix) + ":dataTable") && (attr = element.getAttributeNode("var")) != null && attr.getValue().equals(var)) {
                return true;
            }
            if (element.getName().equals(String.valueOf(this.myfacesPrefix) + ":aliasBean") && (attr = element.getAttributeNode("alias")) != null && this.trimExpression(attr.getValue()).equals(var)) {
                return true;
            }
            FuzzyXMLNode[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                FuzzyXMLAttribute attr2;
                FuzzyXMLElement child;
                if (children[i] instanceof FuzzyXMLElement && (child = (FuzzyXMLElement)children[i]).getName().equals(String.valueOf(this.corePrefix) + ":loadBundle") && (attr2 = child.getAttributeNode("var")) != null && attr2.getValue().equals(var)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String trimExpression(String value) {
        value = value.replaceFirst("^#\\{", "");
        value = value.replaceFirst("\\}$", "");
        value = value.trim();
        return value;
    }

    private int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset);
        return text.split("\n").length;
    }

    private void removeMaker(IResource resouce) throws CoreException {
        resouce.deleteMarkers("org.eclipse.core.resources.problemmarker", false, 0);
    }

    private String createMessage(String key, String param) {
        String message = JSFPlugin.getResourceString(key);
        return Util.createMessage(message, new String[]{param});
    }

    private int getAttrValueOffset(int offset) {
        int valueStart = 0;
        valueStart = this.contents.indexOf("\"", offset);
        if (valueStart == -1) {
            valueStart = this.contents.indexOf("=") + 1;
        }
        return valueStart;
    }

    private void createAttributeValueMarker(FuzzyXMLAttribute attr, String message) throws CoreException {
        this.createMarker(this.getAttrValueOffset(attr.getOffset() + 1), attr.getOffset() + attr.getLength(), this.getLineAtOffset(attr.getOffset() + 1), message);
    }

    private void createMarker(int start, int end, int line, String message) throws CoreException {
        IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("severity", new Integer(2));
        map.put("message", message);
        map.put("lineNumber", new Integer(line));
        map.put("charStart", new Integer(start));
        map.put("charEnd", new Integer(end));
        marker.setAttributes(map);
    }
}

