/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf.editors;

import java.util.ArrayList;
import java.util.ResourceBundle;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlCreator;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.fieldassist.TextControlCreator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.fieldassist.ContentAssistField;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.EditorPart;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.htmleditor.assist.FieldAssistUtils;
import tk.eclipse.plugin.htmleditor.assist.TypeNameContentProposalProvider;
import tk.eclipse.plugin.jsf.JSFPlugin;
import tk.eclipse.plugin.jsf.ManagedBean;
import tk.eclipse.plugin.jsf.ManagedBeanProperty;
import tk.eclipse.plugin.jsf.Util;
import tk.eclipse.plugin.jsf.editors.FacesConfigOperation;

public class ManagedBeanEditor
extends EditorPart {
    private ResourceBundle resource = JSFPlugin.getDefault().getResourceBundle();
    private Composite left;
    private Composite right;
    private boolean dirty = false;
    private Text textName;
    private Text textClass;
    private Combo comboScope;
    private FormToolkit toolkit;
    private ScrolledForm form;
    private TreeViewer treeViewer;
    private RootModel root;
    private Button button1;
    private Button button2;
    private ManagedBean editingModel;
    private FacesConfigOperation operation;

    public ManagedBeanEditor(FacesConfigOperation operation) {
        this.operation = operation;
    }

    public void doSave(IProgressMonitor monitor) {
        this.dirty = false;
        this.right.setVisible(false);
    }

    public void doSaveAs() {
        this.dirty = false;
        this.right.setVisible(false);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createScrolledForm(parent);
        GridLayout layout = new GridLayout(2, false);
        this.form.setText("Managed Beans");
        this.form.getBody().setLayout((Layout)layout);
        this.createLeftArea();
        this.createRightArea();
    }

    private void createLeftArea() {
        this.left = this.toolkit.createComposite(this.form.getBody());
        this.left.setLayoutData((Object)new GridData(1042));
        GridLayout layout = new GridLayout(1, false);
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        this.left.setLayout((Layout)layout);
        Section section1 = this.toolkit.createSection(this.left, 384);
        section1.setText("All Managed Beans");
        section1.setLayoutData((Object)this.createGridData(1, 1808));
        Composite composite = this.toolkit.createComposite((Composite)section1);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        section1.setClient((Control)composite);
        this.root = new RootModel();
        Tree tree = this.toolkit.createTree(composite, 0);
        GridData gd = new GridData(1808);
        gd.widthHint = 250;
        tree.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setContentProvider((IContentProvider)new ManagedBeansContentsProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ManagedBeansLabelProvider());
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                ManagedBean model = ManagedBeanEditor.this.getSelectedManagedBeanModel();
                if (model != null) {
                    ManagedBeanEditor.this.textName.setText(model.getBeanName());
                    ManagedBeanEditor.this.textClass.setText(model.getClassName());
                    if (model.getBeanScope().equals("session")) {
                        ManagedBeanEditor.this.comboScope.select(1);
                    } else if (model.getBeanScope().equals("application")) {
                        ManagedBeanEditor.this.comboScope.select(1);
                    } else {
                        ManagedBeanEditor.this.comboScope.select(0);
                    }
                    ManagedBeanEditor.this.editingModel = model;
                    ManagedBeanEditor.this.right.setVisible(true);
                    ManagedBeanEditor.this.button2.setEnabled(true);
                } else {
                    ManagedBeanEditor.this.editingModel = null;
                    ManagedBeanEditor.this.right.setVisible(false);
                    ManagedBeanEditor.this.button2.setEnabled(false);
                }
            }
        });
        Composite buttons = this.toolkit.createComposite(composite);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginTop = 0;
        buttonLayout.marginBottom = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        buttons.setLayoutData((Object)new GridData(2));
        this.button1 = this.toolkit.createButton(buttons, this.resource.getString("editor.button.add"), 8);
        this.button1.setLayoutData((Object)new GridData(768));
        this.button1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ManagedBeanEditor.this.operation.addManagedBean();
                ManagedBean model = new ManagedBean(ManagedBeanEditor.this.getProject(), "", "", "request");
                ManagedBeanEditor.this.root.beans.addManagedBean(model);
                ManagedBeanEditor.this.treeViewer.refresh();
                ManagedBeanEditor.this.treeViewer.expandAll();
                ManagedBeanEditor.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)model));
                ManagedBeanEditor.this.treeViewer.getTree().setFocus();
                ManagedBeanEditor.this.setDirty();
            }
        });
        this.button2 = this.toolkit.createButton(buttons, this.resource.getString("editor.button.remove"), 8);
        this.button2.setLayoutData((Object)new GridData(768));
        this.button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ManagedBean model;
                IStructuredSelection sel = (IStructuredSelection)ManagedBeanEditor.this.treeViewer.getSelection();
                if (sel != null && sel.getFirstElement() != null && (model = ManagedBeanEditor.this.getSelectedManagedBeanModel()) != null) {
                    ManagedBeanEditor.this.operation.removeManagedBean(ManagedBeanEditor.this.root.beans.getIndex(model));
                    ManagedBeanEditor.this.root.beans.removeManagedBean(model);
                    ManagedBeanEditor.this.treeViewer.refresh();
                    ManagedBeanEditor.this.treeViewer.expandAll();
                    ManagedBeanEditor.this.treeViewer.getTree().setFocus();
                    ManagedBeanEditor.this.setDirty();
                }
            }
        });
        this.button2.setEnabled(false);
        this.toolkit.paintBordersFor(this.left);
    }

    private void createRightArea() {
        this.right = this.toolkit.createComposite(this.form.getBody());
        GridLayout layout = new GridLayout(1, false);
        this.right.setLayout((Layout)layout);
        this.right.setLayoutData((Object)new GridData(770));
        Section section2 = this.toolkit.createSection(this.right, 384);
        section2.setLayoutData((Object)this.createGridData(3, 768));
        section2.setText("Details");
        Composite composite = this.toolkit.createComposite((Composite)section2);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        section2.setClient((Control)composite);
        this.toolkit.createLabel(composite, "name:");
        this.textName = this.toolkit.createText(composite, "", 0);
        this.textName.setLayoutData((Object)this.createGridData(1, 768));
        this.textName.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!ManagedBeanEditor.this.editingModel.getBeanName().equals(ManagedBeanEditor.this.textName.getText())) {
                    ManagedBeanEditor.this.operation.updateManagedBean(ManagedBeanEditor.this.root.beans.getIndex(ManagedBeanEditor.this.editingModel), ManagedBeanEditor.this.textName.getText(), ManagedBeanEditor.this.textClass.getText(), ManagedBeanEditor.this.comboScope.getText());
                    ManagedBeanEditor.this.editingModel.setBeanName(ManagedBeanEditor.this.textName.getText());
                    ManagedBeanEditor.this.treeViewer.refresh();
                    ManagedBeanEditor.this.setDirty();
                }
            }
        });
        Hyperlink link = this.toolkit.createHyperlink(composite, "class:", 0);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                try {
                    String className = ManagedBeanEditor.this.textClass.getText();
                    if (!className.equals("")) {
                        String path = String.valueOf(className.replaceAll("\\.", "/")) + ".java";
                        IJavaProject javaProject = ManagedBeanEditor.this.getProject();
                        IProject project = javaProject.getProject();
                        IFile file = project.getFile(path);
                        IClasspathEntry[] entry = javaProject.getRawClasspath();
                        int i = 0;
                        while (i < entry.length) {
                            if (entry[i].getEntryKind() == 3) {
                                file = project.getFile(entry[i].getPath().removeFirstSegments(1).append(path));
                                break;
                            }
                            ++i;
                        }
                        if (file.exists()) {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            IDE.openEditor((IWorkbenchPage)window.getActivePage(), (IFile)file, (boolean)true);
                        } else {
                            Util.openManagedBeanWizard(ManagedBeanEditor.this.getProject(), className);
                        }
                    }
                }
                catch (Exception ex) {
                    Util.openErrorDialog(ex);
                }
            }
        });
        Composite classContainer = this.toolkit.createComposite(composite);
        GridLayout classContainerLayout = FieldAssistUtils.createNoMarginGridLayout();
        classContainer.setLayout((Layout)classContainerLayout);
        classContainer.setLayoutData((Object)new GridData(768));
        ContentAssistField classField = new ContentAssistField(classContainer, 2048, (IControlCreator)new TextControlCreator(), (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new TypeNameContentProposalProvider(this.getProject()), "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0]);
        this.textClass = (Text)classField.getControl();
        classField.getLayoutControl().setLayoutData((Object)new GridData(768));
        classField.getLayoutControl().setBackground(Display.getDefault().getSystemColor(1));
        this.textClass.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!ManagedBeanEditor.this.editingModel.getClassName().equals(ManagedBeanEditor.this.textClass.getText())) {
                    ManagedBeanEditor.this.operation.updateManagedBean(ManagedBeanEditor.this.root.beans.getIndex(ManagedBeanEditor.this.editingModel), ManagedBeanEditor.this.textName.getText(), ManagedBeanEditor.this.textClass.getText(), ManagedBeanEditor.this.comboScope.getText());
                    ManagedBeanEditor.this.editingModel.setClassName(ManagedBeanEditor.this.textClass.getText());
                    ManagedBeanEditor.this.treeViewer.refresh();
                    ManagedBeanEditor.this.setDirty();
                }
            }
        });
        Button button = this.toolkit.createButton(classContainer, "...", 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String className = ManagedBeanEditor.this.openTypeSelectionDialog();
                if (className != null && !className.equals(ManagedBeanEditor.this.editingModel.getClassName())) {
                    ManagedBeanEditor.this.operation.updateManagedBean(ManagedBeanEditor.this.root.beans.getIndex(ManagedBeanEditor.this.editingModel), ManagedBeanEditor.this.textName.getText(), className, ManagedBeanEditor.this.comboScope.getText());
                    ManagedBeanEditor.this.textClass.setText(className);
                    ManagedBeanEditor.this.editingModel.setClassName(className);
                    ManagedBeanEditor.this.treeViewer.refresh();
                    ManagedBeanEditor.this.setDirty();
                }
            }
        });
        this.toolkit.createLabel(composite, "scope:");
        this.comboScope = new Combo(composite, 0x800008);
        this.comboScope.setLayoutData((Object)this.createGridData(1, 768));
        this.comboScope.add("request");
        this.comboScope.add("session");
        this.comboScope.add("application");
        this.comboScope.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!ManagedBeanEditor.this.editingModel.getBeanScope().equals(ManagedBeanEditor.this.comboScope.getText())) {
                    ManagedBeanEditor.this.operation.updateManagedBean(ManagedBeanEditor.this.root.beans.getIndex(ManagedBeanEditor.this.editingModel), ManagedBeanEditor.this.textName.getText(), ManagedBeanEditor.this.textClass.getText(), ManagedBeanEditor.this.comboScope.getText());
                    ManagedBeanEditor.this.editingModel.setBeanScope(ManagedBeanEditor.this.comboScope.getText());
                    ManagedBeanEditor.this.treeViewer.refresh();
                    ManagedBeanEditor.this.setDirty();
                }
            }
        });
        this.toolkit.paintBordersFor(classContainer);
        this.toolkit.paintBordersFor(composite);
        this.right.setVisible(false);
    }

    private void setDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    private GridData createGridData(int span, int option) {
        GridData gd = new GridData(option);
        gd.horizontalSpan = span;
        gd.horizontalIndent = 5;
        return gd;
    }

    private String openTypeSelectionDialog() {
        try {
            IJavaProject project = this.getProject();
            if (project != null) {
                Shell shell = this.treeViewer.getControl().getShell();
                SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}), (int)2, (boolean)false);
                if (dialog.open() == 0) {
                    Object[] result = dialog.getResult();
                    return ((IType)result[0]).getFullyQualifiedName();
                }
            }
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
        return null;
    }

    private ManagedBean getSelectedManagedBeanModel() {
        Object obj;
        IStructuredSelection sel = (IStructuredSelection)this.treeViewer.getSelection();
        if (sel != null && sel.getFirstElement() != null && (obj = sel.getFirstElement()) instanceof ManagedBean) {
            return (ManagedBean)obj;
        }
        return null;
    }

    private IJavaProject getProject() {
        IProject project = ((IFileEditorInput)this.getEditorInput()).getFile().getProject();
        return JavaCore.create((IProject)project);
    }

    public void setFocus() {
        this.form.setFocus();
    }

    public void dispose() {
        this.toolkit.dispose();
        super.dispose();
    }

    public void update(String source) {
        FuzzyXMLDocument doc = new FuzzyXMLParser().parse(source);
        FuzzyXMLNode[] beans = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/faces-config/managed-bean");
        ManagedBeansModel model = new ManagedBeansModel();
        int i = 0;
        while (i < beans.length) {
            String name = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)beans[i]), (String)"/managed-bean-name");
            String className = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)beans[i]), (String)"/managed-bean-class");
            String scope = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)beans[i]), (String)"/managed-bean-scope");
            ManagedBean bean = new ManagedBean(this.getProject(), className, name, scope);
            FuzzyXMLNode[] props = XPath.selectNodes((FuzzyXMLElement)((FuzzyXMLElement)beans[i]), (String)"/managed-property");
            StringBuffer sb = new StringBuffer();
            int j = 0;
            while (j < props.length) {
                sb.append(props[j].toXMLString());
                ++j;
            }
            bean.setManagedProperty(sb.toString());
            model.addManagedBean(bean);
            ++i;
        }
        this.root.beans = model;
        this.treeViewer.refresh();
        this.treeViewer.expandAll();
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)model));
        this.treeViewer.getTree().setFocus();
    }

    private class RootModel {
        private ManagedBeansModel beans;

        private RootModel() {
            this.beans = new ManagedBeansModel();
        }
    }

    private class ManagedBeansModel {
        private ArrayList beans = new ArrayList();

        private ManagedBeansModel() {
        }

        public int getIndex(ManagedBean model) {
            int i = 0;
            while (i < this.beans.size()) {
                if (this.beans.get(i) == model) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void addManagedBean(ManagedBean model) {
            this.beans.add(model);
        }

        private void removeManagedBean(ManagedBean model) {
            this.beans.remove(model);
        }

        private ManagedBean[] getManagedBeans() {
            return this.beans.toArray(new ManagedBean[this.beans.size()]);
        }
    }

    private class ManagedBeansContentsProvider
    implements ITreeContentProvider {
        private ManagedBeansContentsProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof RootModel) {
                return new Object[]{((RootModel)parentElement).beans};
            }
            if (parentElement instanceof ManagedBeansModel) {
                return ((ManagedBeansModel)parentElement).getManagedBeans();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof ManagedBeansModel) {
                return ManagedBeanEditor.this.root;
            }
            if (element instanceof ManagedBean) {
                return ManagedBeanEditor.this.root.beans;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children.length != 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ManagedBeansLabelProvider
    extends LabelProvider {
        private ManagedBeansLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof ManagedBeansModel) {
                return JSFPlugin.getDefault().getImage("__icon_beans");
            }
            if (element instanceof ManagedBean) {
                return JSFPlugin.getDefault().getImage("__icon_bean");
            }
            if (element instanceof ManagedBeanProperty) {
                return JSFPlugin.getDefault().getImage("__icon_prop");
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ManagedBeansModel) {
                return "Managed-Beans";
            }
            if (element instanceof ManagedBean) {
                return ((ManagedBean)element).getBeanName();
            }
            if (element instanceof ManagedBeanProperty) {
                return ((ManagedBeanProperty)element).getPropertyName();
            }
            return super.getText(element);
        }
    }
}

