package net.java.amateras.db.visual.model;

import net.java.amateras.db.DBPlugin;

import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class TableModel extends AbstractDBEntityModel {
	
	private String tableName = "";
	private ColumnModel[] columns = new ColumnModel[0];
	
	public static final String P_TABLE_NAME = "p_table_name";
	public static final String P_COLUMNS = "p_columns";
	public static final String P_CONSTRAINT = "p_constraint";
	
	public void setTableName(String tableName){
		this.tableName = tableName;
		firePropertyChange(P_TABLE_NAME, null, tableName);
	}
	
	public String getTableName(){
		return this.tableName;
	}
	
	public void setColumns(ColumnModel[] columns){
		this.columns = columns;
		firePropertyChange(P_COLUMNS, null, columns);
	}
	
	public ColumnModel[] getColumns(){
		return this.columns;
	}
	
	public ColumnModel getColumn(String columnName){
		for(int i=0;i<columns.length;i++){
			if(columns[i].getColumnName().equals(columnName)){
				return columns[i];
			}
		}
		return null;
	}
	
	public IPropertyDescriptor[] getPropertyDescriptors() {
		return new IPropertyDescriptor[]{
				new TextPropertyDescriptor(P_TABLE_NAME, DBPlugin.getDefault().getResourceString("property.tableName"))
		};
	}
	
	public Object getPropertyValue(Object id) {
		if(id == P_TABLE_NAME){
			return getTableName();
		}
		return null;
	}
	
	public boolean isPropertySet(Object id) {
		if(id == P_TABLE_NAME){
			return true;
		}
		return false;
	}
	
	
	public void setPropertyValue(Object id, Object value) {
		if(id == P_TABLE_NAME){
			setTableName((String)value);
		}
	}

	
}
