package net.java.amateras.db.visual.editpart;

import net.java.amateras.db.visual.model.ForeignKeyMapping;
import net.java.amateras.db.visual.model.ForeignKeyModel;
import net.java.amateras.db.visual.model.TableModel;

import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;

public class ForeignKeyEditPart extends AbstractDBConnectionEditPart {
	
	private Label label;
	
	protected IFigure createFigure() {
		PolylineConnection connection = new PolylineConnection();
		ManhattanConnectionRouter router = new ManhattanConnectionRouter();
		connection.setConnectionRouter(router);
		
		PolygonDecoration decoration = new PolygonDecoration();
		connection.setTargetDecoration(decoration);
		
		label = new Label();
		label.setLabelAlignment(PositionConstants.CENTER);
		label.setOpaque(true);
		label.setBackgroundColor(Display.getDefault().getSystemColor(SWT.COLOR_WHITE));
		updateLabel();
		connection.add(label, new ConnectionLocator(connection, ConnectionLocator.MIDDLE));
		
		return connection;
	}
	
	private void updateLabel(){
		ForeignKeyModel model = (ForeignKeyModel)getModel();
		ForeignKeyMapping[] mapping = model.getMapping();
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<mapping.length;i++){
			try {
				sb.append(mapping[i].toString());
				sb.append("\n");
			} catch(Exception ex){
				ex.printStackTrace();
			}
		}
		label.setText(sb.toString());
	}

	protected void refreshVisuals() {
		super.refreshVisuals();
		updateLabel();
	}
	
	public void doubleClicked(){
		ForeignKeyModel model = (ForeignKeyModel)getModel();
		ForeignKeyEditDialog dialog = new ForeignKeyEditDialog(
				getViewer().getControl().getShell(),
				model.getForeignKeyName(), model.getMapping(), 
				((TableModel)model.getSource()).getColumns());
		
		if(dialog.open()==Dialog.OK){
			model.setForeignKeyName(dialog.getForeignKeyName());
			model.setMapping(dialog.getMapping());
		}
	}
	
	
	
}
