package net.java.amateras.db;

import java.util.ResourceBundle;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class DBPlugin extends AbstractUIPlugin {

	//The shared instance.
	private static DBPlugin plugin;
	
	public static final String PLUGIN_ID = "net.java.amateras.db.DBPlugin";
	private ResourceBundle resource = null;
	
	
	/**
	 * The constructor.
	 */
	public DBPlugin() {
		plugin = this;
		resource = ResourceBundle.getBundle(PLUGIN_ID);
	}
	
	public String getResourceString(String key){
		return resource.getString(key);
	}
	
	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static DBPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("net.java.amateras.db", path);
	}
	
	public static void logException(Exception ex){
		IStatus status = new Status(IStatus.ERROR, PLUGIN_ID, IStatus.ERROR, "Error", ex);
		getDefault().getLog().log(status);
		ex.printStackTrace(); // TODO Debug
	}
	
	public String createMessage(String key, String[] values){
		String message = getResourceString(key);
		for(int i=0;i<values.length;i++){
			message = message.replaceAll("\\{"+i+"\\}", values[i]);
		}
		return message;
	}
}
