/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.webapp.FacetTag;
import javax.faces.webapp._PageContextOutWriter;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public abstract class UIComponentTag
implements Tag {
    private static final String FORMER_CHILD_IDS_SET_ATTR = (class$javax$faces$webapp$UIComponentTag == null ? (class$javax$faces$webapp$UIComponentTag = UIComponentTag.class$("javax.faces.webapp.UIComponentTag")) : class$javax$faces$webapp$UIComponentTag).getName() + ".FORMER_CHILD_IDS";
    private static final String FORMER_FACET_NAMES_SET_ATTR = (class$javax$faces$webapp$UIComponentTag == null ? (class$javax$faces$webapp$UIComponentTag = UIComponentTag.class$("javax.faces.webapp.UIComponentTag")) : class$javax$faces$webapp$UIComponentTag).getName() + ".FORMER_FACET_NAMES";
    private static final String COMPONENT_STACK_ATTR = (class$javax$faces$webapp$UIComponentTag == null ? (class$javax$faces$webapp$UIComponentTag = UIComponentTag.class$("javax.faces.webapp.UIComponentTag")) : class$javax$faces$webapp$UIComponentTag).getName() + ".COMPONENT_STACK";
    protected PageContext pageContext = null;
    private Tag _parent = null;
    private String _binding = null;
    private String _id = null;
    private String _rendered = null;
    private FacesContext _facesContext = null;
    private UIComponent _componentInstance = null;
    private boolean _created = false;
    private Boolean _suppressed = null;
    private ResponseWriter _writer = null;
    private Set _childrenAdded = null;
    private Set _facetsAdded = null;
    static /* synthetic */ Class class$javax$faces$webapp$UIComponentTag;

    public void release() {
        this.internalRelease();
        this.pageContext = null;
        this._parent = null;
        this._binding = null;
        this._id = null;
        this._rendered = null;
    }

    private void internalRelease() {
        this._facesContext = null;
        this._componentInstance = null;
        this._created = false;
        this._suppressed = null;
        this._writer = null;
        this._childrenAdded = null;
        this._facetsAdded = null;
    }

    public void setBinding(String binding) throws JspException {
        if (!UIComponentTag.isValueReference(binding)) {
            throw new IllegalArgumentException("not a valid binding: " + binding);
        }
        this._binding = binding;
    }

    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setRendered(String rendered) {
        this._rendered = rendered;
    }

    public abstract String getComponentType();

    public UIComponent getComponentInstance() {
        return this._componentInstance;
    }

    public boolean getCreated() {
        return this._created;
    }

    public static UIComponentTag getParentUIComponentTag(PageContext pageContext) {
        List list = (List)pageContext.getAttribute(COMPONENT_STACK_ATTR, 2);
        if (list != null) {
            return (UIComponentTag)list.get(list.size() - 1);
        }
        return null;
    }

    private void popTag() {
        List list = (List)this.pageContext.getAttribute(COMPONENT_STACK_ATTR, 2);
        if (list != null) {
            int size = list.size();
            list.remove(size - 1);
            if (size <= 1) {
                this.pageContext.removeAttribute(COMPONENT_STACK_ATTR, 2);
            }
        }
    }

    private void pushTag() {
        ArrayList<UIComponentTag> list = (ArrayList<UIComponentTag>)this.pageContext.getAttribute(COMPONENT_STACK_ATTR, 2);
        if (list == null) {
            list = new ArrayList<UIComponentTag>();
            this.pageContext.setAttribute(COMPONENT_STACK_ATTR, list, 2);
        }
        list.add(this);
    }

    public abstract String getRendererType();

    public static boolean isValueReference(String value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public Tag getParent() {
        return this._parent;
    }

    public void setParent(Tag parent) {
        this._parent = parent;
    }

    public int doStartTag() throws JspException {
        this.setupResponseWriter();
        FacesContext facesContext = this.getFacesContext();
        UIComponent component = this.findComponent(facesContext);
        if (!component.getRendersChildren() && !this.isSuppressed()) {
            try {
                this.encodeBegin();
                this._writer.flush();
            }
            catch (IOException e) {
                throw new JspException(e.getMessage(), (Throwable)e);
            }
        }
        this.pushTag();
        return this.getDoStartValue();
    }

    public int doEndTag() throws JspException {
        this.popTag();
        UIComponent component = this.getComponentInstance();
        this.removeFormerChildren(component);
        this.removeFormerFacets(component);
        try {
            if (!this.isSuppressed()) {
                if (component.getRendersChildren()) {
                    this.encodeBegin();
                    this.encodeChildren();
                }
                this.encodeEnd();
            }
        }
        catch (IOException e) {
            throw new JspException(e.getMessage(), (Throwable)e);
        }
        int retValue = this.getDoEndValue();
        this.internalRelease();
        return retValue;
    }

    private void removeFormerChildren(UIComponent component) {
        Set formerChildIdsSet = (Set)component.getAttributes().get(FORMER_CHILD_IDS_SET_ATTR);
        if (formerChildIdsSet != null) {
            Iterator iterator = formerChildIdsSet.iterator();
            while (iterator.hasNext()) {
                UIComponent childToRemove;
                String childId = (String)iterator.next();
                if (this._childrenAdded != null && this._childrenAdded.contains(childId) || (childToRemove = component.findComponent(childId)) == null) continue;
                component.getChildren().remove(childToRemove);
            }
            if (this._childrenAdded == null) {
                component.getAttributes().remove(FORMER_CHILD_IDS_SET_ATTR);
            } else {
                component.getAttributes().put(FORMER_CHILD_IDS_SET_ATTR, this._childrenAdded);
            }
        } else if (this._childrenAdded != null) {
            component.getAttributes().put(FORMER_CHILD_IDS_SET_ATTR, this._childrenAdded);
        }
    }

    private void removeFormerFacets(UIComponent component) {
        Set formerFacetNamesSet = (Set)component.getAttributes().get(FORMER_FACET_NAMES_SET_ATTR);
        if (formerFacetNamesSet != null) {
            Iterator iterator = formerFacetNamesSet.iterator();
            while (iterator.hasNext()) {
                String facetName = (String)iterator.next();
                if (this._facetsAdded != null && this._facetsAdded.contains(facetName)) continue;
                component.getFacets().remove(facetName);
            }
            if (this._facetsAdded == null) {
                component.getAttributes().remove(FORMER_FACET_NAMES_SET_ATTR);
            } else {
                component.getAttributes().put(FORMER_FACET_NAMES_SET_ATTR, this._facetsAdded);
            }
        } else if (this._facetsAdded != null) {
            component.getAttributes().put(FORMER_FACET_NAMES_SET_ATTR, this._facetsAdded);
        }
    }

    protected void encodeBegin() throws IOException {
        this._componentInstance.encodeBegin(this.getFacesContext());
    }

    protected void encodeChildren() throws IOException {
        this._componentInstance.encodeChildren(this.getFacesContext());
    }

    protected void encodeEnd() throws IOException {
        this._componentInstance.encodeEnd(this.getFacesContext());
    }

    protected UIComponent findComponent(FacesContext context) throws JspException {
        if (this._componentInstance != null) {
            return this._componentInstance;
        }
        UIComponentTag parentTag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        if (parentTag == null) {
            this._componentInstance = context.getViewRoot();
            this.setProperties(this._componentInstance);
            return this._componentInstance;
        }
        UIComponent parent = parentTag.getComponentInstance();
        if (parent == null) {
            throw new IllegalStateException("parent is null?");
        }
        String facetName = this.getFacetName();
        if (facetName != null) {
            String id = this.getOrCreateUniqueId(context);
            this._componentInstance = parent.getFacet(facetName);
            if (this._componentInstance == null) {
                this._componentInstance = this.createComponentInstance(context, id);
                this.setProperties(this._componentInstance);
                parent.getFacets().put(facetName, this._componentInstance);
            }
            this.addFacetNameToParentTag(parentTag, facetName);
            return this._componentInstance;
        }
        String id = this.getOrCreateUniqueId(context);
        this._componentInstance = parent.findComponent(id);
        if (this._componentInstance == null) {
            this._componentInstance = this.createComponentInstance(context, id);
            this.setProperties(this._componentInstance);
            int index = this.getAddedChildrenCount(parentTag);
            List children = parent.getChildren();
            if (index <= children.size()) {
                children.add(index, this._componentInstance);
            } else {
                throw new FacesException("cannot add component with id '" + this._componentInstance.getId() + "' and path : " + UIComponentTag.getPathToComponent(this._componentInstance) + " to its parent component. This might be a problem due to duplicate ids.");
            }
        }
        this.addChildIdToParentTag(parentTag, id);
        return this._componentInstance;
    }

    private String getOrCreateUniqueId(FacesContext context) {
        String id = this.getId();
        if (id != null) {
            return id;
        }
        return context.getViewRoot().createUniqueId();
    }

    private UIComponent createComponentInstance(FacesContext context, String id) {
        String componentType = this.getComponentType();
        if (componentType == null) {
            throw new NullPointerException("componentType");
        }
        if (this._binding != null) {
            Application application = context.getApplication();
            ValueBinding componentBinding = application.createValueBinding(this._binding);
            UIComponent component = application.createComponent(componentBinding, context, componentType);
            component.setId(id);
            component.setValueBinding("binding", componentBinding);
            this.recurseFacetsAndChildrenForId(context, component.getFacetsAndChildren(), id + "_", 0);
            this._created = true;
            return component;
        }
        UIComponent component = context.getApplication().createComponent(componentType);
        component.setId(id);
        this._created = true;
        return component;
    }

    private int recurseFacetsAndChildrenForId(FacesContext context, Iterator facetsAndChildren, String idPrefix, int cnt) {
        while (facetsAndChildren.hasNext()) {
            UIComponent comp = (UIComponent)facetsAndChildren.next();
            if (comp.getId() == null) {
                comp.setId(idPrefix + ++cnt);
            }
            cnt = this.recurseFacetsAndChildrenForId(context, comp.getFacetsAndChildren(), idPrefix, cnt);
        }
        return cnt;
    }

    private void addChildIdToParentTag(UIComponentTag parentTag, String id) {
        if (parentTag._childrenAdded == null) {
            parentTag._childrenAdded = new HashSet();
        }
        parentTag._childrenAdded.add(id);
    }

    private void addFacetNameToParentTag(UIComponentTag parentTag, String facetName) {
        if (parentTag._facetsAdded == null) {
            parentTag._facetsAdded = new HashSet();
        }
        parentTag._facetsAdded.add(facetName);
    }

    private int getAddedChildrenCount(UIComponentTag parentTag) {
        return parentTag._childrenAdded != null ? parentTag._childrenAdded.size() : 0;
    }

    protected int getDoStartValue() throws JspException {
        return 1;
    }

    protected int getDoEndValue() throws JspException {
        return 6;
    }

    protected FacesContext getFacesContext() {
        if (this._facesContext == null) {
            this._facesContext = FacesContext.getCurrentInstance();
        }
        return this._facesContext;
    }

    private boolean isFacet() {
        return this._parent != null && this._parent instanceof FacetTag;
    }

    protected String getFacetName() {
        return this.isFacet() ? ((FacetTag)this._parent).getName() : null;
    }

    protected boolean isSuppressed() {
        if (this._suppressed == null) {
            if (this.isFacet()) {
                this._suppressed = Boolean.TRUE;
                return this._suppressed;
            }
            UIComponent component = this.getComponentInstance();
            UIComponent parent = component.getParent();
            while (parent != null) {
                if (parent.getRendersChildren()) {
                    this._suppressed = Boolean.TRUE;
                    return this._suppressed;
                }
                parent = parent.getParent();
            }
            while (component != null) {
                if (!component.isRendered()) {
                    this._suppressed = Boolean.TRUE;
                    return this._suppressed;
                }
                component = component.getParent();
            }
            this._suppressed = Boolean.FALSE;
        }
        return this._suppressed;
    }

    protected void setProperties(UIComponent component) {
        if (this.getRendererType() != null) {
            this._componentInstance.setRendererType(this.getRendererType());
        }
        if (this._rendered != null) {
            if (UIComponentTag.isValueReference(this._rendered)) {
                ValueBinding vb = this.getFacesContext().getApplication().createValueBinding(this._rendered);
                component.setValueBinding("rendered", vb);
            } else {
                boolean b = Boolean.valueOf(this._rendered);
                component.setRendered(b);
            }
        }
    }

    protected void setupResponseWriter() {
        FacesContext facesContext = this.getFacesContext();
        this._writer = facesContext.getResponseWriter();
        if (this._writer == null) {
            RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory("javax.faces.render.RenderKitFactory");
            RenderKit renderKit = renderFactory.getRenderKit(facesContext, facesContext.getViewRoot().getRenderKitId());
            this._writer = renderKit.createResponseWriter(new _PageContextOutWriter(this.pageContext), this.pageContext.getRequest().getContentType(), this.pageContext.getRequest().getCharacterEncoding());
            facesContext.setResponseWriter(this._writer);
        }
    }

    public static String getPathToComponent(UIComponent component) {
        StringBuffer buf = new StringBuffer();
        if (component == null) {
            buf.append("{Component-Path : ");
            buf.append("[null]}");
            return buf.toString();
        }
        UIComponentTag.getPathToComponent(component, buf);
        buf.insert(0, "{Component-Path : ");
        buf.append("}");
        return buf.toString();
    }

    private static void getPathToComponent(UIComponent component, StringBuffer buf) {
        if (component == null) {
            return;
        }
        StringBuffer intBuf = new StringBuffer();
        intBuf.append("[Class: ");
        intBuf.append(component.getClass().getName());
        if (component instanceof UIViewRoot) {
            intBuf.append(",ViewId: ");
            intBuf.append(((UIViewRoot)component).getViewId());
        } else {
            intBuf.append(",Id: ");
            intBuf.append(component.getId());
        }
        intBuf.append("]");
        buf.insert(0, (Object)intBuf);
        if (component != null) {
            UIComponentTag.getPathToComponent(component.getParent(), buf);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

