/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.jsf;

import java.io.InputStream;
import java.util.ArrayList;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import jp.aonir.fuzzyxml.internal.FuzzyXMLUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.jsf.ManagedBean;

public class JSFProject {
    private IJavaProject project;

    public JSFProject(IJavaProject project) {
        this.project = project;
    }

    public ManagedBean[] getManagedBeans() {
        try {
            IFile[] files = this.getFacesConfigXML();
            ArrayList<ManagedBean> list = new ArrayList<ManagedBean>();
            int j = 0;
            while (j < files.length) {
                InputStream in = files[j].getContents();
                FuzzyXMLDocument doc = new FuzzyXMLParser().parse(new String(FuzzyXMLUtil.readStream((InputStream)in)));
                in.close();
                FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)doc.getDocumentElement(), (String)"/faces-config/managed-bean");
                int i = 0;
                while (i < nodes.length) {
                    String name = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)nodes[i]), (String)"/managed-bean-name");
                    String clazz = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)nodes[i]), (String)"/managed-bean-class");
                    String scope = HTMLUtil.getXPathValue((FuzzyXMLElement)((FuzzyXMLElement)nodes[i]), (String)"/managed-bean-scope");
                    if (name != null && !name.equals("") && clazz != null && !clazz.equals("")) {
                        list.add(new ManagedBean(this.project, clazz, name, scope));
                    }
                    ++i;
                }
                ++j;
            }
            return list.toArray(new ManagedBean[list.size()]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new ManagedBean[0];
        }
    }

    public ManagedBean getManagedBean(String beanName) {
        ManagedBean[] beans = this.getManagedBeans();
        int i = 0;
        while (i < beans.length) {
            if (beans[i].getBeanName().equals(beanName)) {
                return beans[i];
            }
            ++i;
        }
        return null;
    }

    public IFile[] getFacesConfigXML() {
        try {
            FuzzyXMLDocument doc;
            String value;
            HTMLProjectParams params = new HTMLProjectParams(this.project.getProject());
            IPath path = new Path(params.getRoot()).append("/WEB-INF/web.xml");
            IFile file = this.project.getProject().getFile(path);
            if (file != null && file.exists() && (value = HTMLUtil.getXPathValue((FuzzyXMLElement)(doc = new FuzzyXMLParser().parse(file.getContents())).getDocumentElement(), (String)"/web-app/context-param[param-name='javax.faces.CONFIG_FILES']/param-value")) != null) {
                String[] names = value.split(",");
                ArrayList<IFile> files = new ArrayList<IFile>();
                int i = 0;
                while (i < names.length) {
                    path = new Path(params.getRoot()).append(names[i].trim());
                    file = this.project.getProject().getFile(path);
                    if (file != null && file.exists()) {
                        files.add(file);
                    }
                    ++i;
                }
                return files.toArray(new IFile[files.size()]);
            }
            path = new Path(params.getRoot()).append("/WEB-INF/faces-config.xml");
            file = this.project.getProject().getFile(path);
            if (file != null && file.exists()) {
                return new IFile[]{file};
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new IFile[0];
    }
}

