#ifndef ALTTCPSOCKET_H
#define ALTTCPSOCKET_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTCPSocket.h 720 2007-11-26 09:04:32Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altTCPSocket.h
 * \brief   TCP Socket
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altSocket.h>
#include <altBase/altStr.h>

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  TCP Socket Class
///
class altTCPSocket : public altSocket
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altTCPSocket();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTCPSocket();

  ///
  /// \brief  Connect
  ///
  /// \param  sHost [I ] Host name or IP address
  /// \param  nPort [I ] Port number
  ///
  /// \return ALT_S_SUCCESS       success
  /// \retrun ALT_E_CONNECT       connect error
  /// \return	ALT_E_SOCKET        create socket error
  /// \return ALT_E_UNKOWN_HOST   unknown host error
  ///
  LIBALT_API virtual alt_t Connect(const altStr & sHost, const altInt nPort);

  ///
  /// \brief  Disconnect
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API virtual alt_t Disconnect();
};

#endif
