#ifndef ALTTCPSERVER_H
#define ALTTCPSERVER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altTCPServer.h 794 2008-01-21 06:44:31Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altTCPServer.h
 * \brief   TCP Network Server
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETConnectionManager.h>
#include <altNet/altTCPAcceptor.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>
#include <altBase/altSyncThread.h>
#include <altBase/altUncopyable.h>

#include <map>

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
///
/// \brief  Get TCP Server Instance
///
#define aiTCPServer altTCPServer::GetInstance()

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altTCPAcceptor;
typedef std::map<altInt, altTCPAcceptor *> altTCPAcceptorMap;   ///< TCP Acceptor Map

/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  TCP Server Class
///
class altTCPServer : public altSingleton<altTCPServer>, protected altSyncThread
{
friend class altSingleton<altTCPServer>;
protected:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altTCPServer();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altTCPServer();

public:
  ///
  /// \brief  Open Port
  ///
  /// \param  nPort               [I ] Port NO
  /// \param  pReceiveCallBack    [I ] Receive Call Back Function
  /// \param  pAcceptCallBack     [I ] Accept Call Back Function
  /// \param  pDisconnectCallBack [I ] Disconnected Call Back Function
  /// \param  nThreadCount        [I ] Request Thread Count
  /// \param  nListenQueSize      [I ] Listen Que Size
  ///
  /// \return ALT_S_SUCCESS     success
  /// \return ALT_E_WSASTARTUP  start up error
  /// \return ALT_E_WSAVERSION  WinSock version error
  /// \return ALT_E_NOMEM       Out Of Memory error
  /// \return ALT_E_INVAL       Invalid Paramter
  ///
  LIBALT_API alt_t OpenPort(const altInt nPort, const altNETReceiveCallBack pReceiveCallBack, const altNETAcceptCallBack pAcceptCallBack = NULL, const altNETDisconnectCallBackFunc pDisconnectCallBack = NULL, const altUInt nThreadCount = 10, const altInt nListenQueSize = 5);

  ///
  /// \brief  Close Port
  ///
  /// \param  nPort   [I ] Port NO
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t ClosePort(const altInt nPort);

  ///
  /// \brief  Close All Port
  ///
  /// \return ALT_S_SUCCESS   success
  ///
  LIBALT_API alt_t ClosePortAll();

  ///
  /// \brief  Close all client connection
  ///
  LIBALT_API void CloseAllClientConnection();

  ///
  /// \brief  Get Instance
  ///
  /// \return Instance
  ///
  LIBALT_API static altTCPServer & GetInstance();

protected:
  ///
  /// \brief  ReStart Threads
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t ReStartThreads();

  altTCPAcceptorMap m_oAcceptorMap; ///< TCP Acceptor Map
};
#endif  //ALTNETTCPSERVER_H
