#ifndef ALTNETCOMMON_H
#define ALTNETCOMMON_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNetCommon.h 712 2007-11-23 01:34:05Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altNetCommon.h
 * \brief   Network Common Function
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altBase/altCommon.h>
#ifdef ALT_LINUX
  #include <sys/types.h>
  #include <sys/socket.h>
  #include <netinet/in.h>
  #include <arpa/inet.h>
#endif

/*----------------------------------------------------------------*
 * Define
 *----------------------------------------------------------------*/
#define ALT_NO_SSL  0x00    ///< No SSL
#define ALT_SSL_V23 0x01    ///< SSL ver2,3
#define ALT_SSL_V2  0x02    ///< SSL ver2
#define ALT_SSL_V3  0x03    ///< SSL ver3
#define ALT_TSL_V1  0x04    ///< TSL ver1

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
#ifdef ALT_LINUX
  typedef int                 SOCKET;
  typedef struct sockaddr     SOCKADDR;
  typedef struct sockaddr_in  SOCKADDR_IN;
  typedef struct hostent *    LPHOSTENT;
  typedef unsigned int *      LPIN_ADDR;
#endif


#endif  //ALTNETCOMMON_H

