#ifndef ALTNETSENDBROKER_H
#define ALTNETSENDBROKER_H
/*--------------------------------------------------------------------------*

   Alternative Llibrary

  $Id: altNETSenderBroker.h 796 2008-01-21 08:19:28Z nekosys $

  Copyright (C) 2007 NEKO SYSTEM
 
  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *---------------------------------------------------------------------------*/
/**
 * \file    altNetNETSendBroker.h
 * \brief   NET Network Send Broker
 * \date    2007
 * \author  NEKO SYSTEM
 */
/*----------------------------------------------------------------*
 * Include
 *----------------------------------------------------------------*/
#include <altNet/altNETSender.h>
#include <altBase/altPtr.h>
#include <altBase/altLog.h>
#include <altBase/altStatus.h>
#include <altBase/altSyncThread.h>

#include <vector>

/*----------------------------------------------------------------*
 * Type Definition
 *----------------------------------------------------------------*/
class altNETConnectionManager;
class altNETConnection;
class altNETSender;

typedef std::vector<altNETSender *> altNetNETSenderContainer;


/*----------------------------------------------------------------*
 * Class Definition
 *----------------------------------------------------------------*/
///
/// \brief  NET Send Broker
///
class altNETSenderBroker : public altBase, protected altSyncThread
{
public:
  ///
  /// \brief  Constructor
  ///
  LIBALT_API altNETSenderBroker();

  ///
  /// \brief  Destructor
  ///
  LIBALT_API virtual ~altNETSenderBroker();

  ///
  /// \brief  Send
  ///
  /// \param  nSocket  [I ] socket
  /// \param  pData    [I ] data
  /// \param  nSize    [I ] data size
  ///
  /// \return ALT_S_SUCCESS   success
  /// \return ALT_E_NOMEM     out of memory
  /// \return ALT_E_ERROR     error
  ///
  LIBALT_API alt_t Send(const altCNETConnectionPtr & pConnection, const altCharPtr & pData, const altInt nSize) const;

protected:
  ///
  /// \brief  Create New Sender
  ///
  /// \return ALT_S_SUCCESS success
  ///
  LIBALT_API alt_t CreateNewSender() const;

  ///
  /// \brief  Deleter Thread
  ///
  /// \param  pParam  [IO] this object
  ///
  LIBALT_API static alt_t DeleterThread(void * pParam);

  mutable altNetNETSenderContainer  m_oNETSenderContainer;    ///< NET Sender Container
  altLoopThread                     m_oDeleterThread;         ///< Deleter Thread
};
#endif  //ALTNETNETSENDBROKER_H
